<?php
/**
 * Defines the RawapiSearchAddressRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Search for full address using the current Address lookup provider
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiSearchAddressRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiSearchAddressRequest.
 */
abstract class RawapiSearchAddressRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiSearchAddress';

  /**
   * A `ViaApiAddressDetails` object containing the address to search for.
   *
   * @var \Red61\Via\DataObject\ViaApiAddressDetails
   */
  protected $addressDetails;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * A `ViaApiAddressDetails` object containing the address to search for.
   *
   * @return \Red61\Via\DataObject\ViaApiAddressDetails
   */
  public function getAddressDetails()
  {
    return $this->addressDetails;
  }


  /**
   * A `ViaApiAddressDetails` object containing the address to search for.
   *
   * @param \Red61\Via\DataObject\ViaApiAddressDetails $addressDetails
   *
   * @return $this
   */
  public function setAddressDetails($addressDetails)
  {
    $this->addressDetails = $addressDetails;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
