<?php
/**
 * Defines the RawapiGetCustomerDigitalAssetsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Return All the event and performances which have a digital asset. i.e physical event using eTickets or online content
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetCustomerDigitalAssetsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetCustomerDigitalAssetsRequest.
 */
abstract class RawapiGetCustomerDigitalAssetsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetCustomerDigitalAssets';

  /**
   * 
   *
   * @var bool
   */
  protected $includeEtickets;

  /**
   * 
   *
   * @var bool
   */
  protected $includePerformancesInPast;

  /**
   * 
   *
   * @var int
   */
  protected $customerId;

  /**
   * 
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * 
   *
   * @return bool
   */
  public function getIncludeEtickets()
  {
    return $this->includeEtickets;
  }


  /**
   * 
   *
   * @param bool $includeEtickets
   *
   * @return $this
   */
  public function setIncludeEtickets($includeEtickets)
  {
    $this->includeEtickets = $includeEtickets;
    return $this;
  }

  /**
   * 
   *
   * @return bool
   */
  public function getIncludePerformancesInPast()
  {
    return $this->includePerformancesInPast;
  }


  /**
   * 
   *
   * @param bool $includePerformancesInPast
   *
   * @return $this
   */
  public function setIncludePerformancesInPast($includePerformancesInPast)
  {
    $this->includePerformancesInPast = $includePerformancesInPast;
    return $this;
  }

  /**
   * 
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * 
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * 
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * 
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
