<?php
/**
 * Defines the RawViaApiCompanyConsentQuestion data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * A data protection consent question, with a list of `ViaApiCompany`s to ask the question for. Requests the customer's
 * consent for each company to contact them or otherwise process their personal data (for marketing purposes, etc.)
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiCompanyConsentQuestion.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiCompanyConsentQuestion.
 */
abstract class RawViaApiCompanyConsentQuestion {

  /**
   * The question's id
   *
   * @var int
   */
  protected $consentQuestionId;

  /**
   * The title for this question
   *
   * @var string
   */
  protected $title;

  /**
   * The question text
   *
   * @var string
   */
  protected $question;

  /**
   * Additional information about this question
   *
   * @var string
   */
  protected $description;

  /**
   * The scope of this question.
   * 
   * Possible values:
   * 
   * `GLOBAL` - a global question, with no basket context
   * 
   * `COMPANY` - a company-specific question, related to what is purchased by the customer
   *
   * @var string
   */
  protected $scope;

  /**
   * The available options to consent to for this question
   *
   * @var \Red61\Via\DataObject\ViaApiConsentOption[]
   */
  protected $consentOptions;

  /**
   * List of companies this question is to be asked on behalf of
   *
   * @var \Red61\Via\DataObject\ViaApiCompany[]
   */
  protected $companies;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'consentQuestionId':
        return $this->getConsentQuestionId();
      case 'title':
        return $this->getTitle();
      case 'question':
        return $this->getQuestion();
      case 'description':
        return $this->getDescription();
      case 'scope':
        return $this->getScope();
      case 'consentOptions':
        return $this->getConsentOptions();
      case 'companies':
        return $this->getCompanies();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The question's id
   *
   * @return int
   */
  public function getConsentQuestionId()
  {
    return $this->consentQuestionId;
  }


  /**
   * The title for this question
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The question text
   *
   * @return string
   */
  public function getQuestion()
  {
    return $this->question;
  }


  /**
   * Additional information about this question
   *
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }


  /**
   * The scope of this question.
   * 
   * Possible values:
   * 
   * `GLOBAL` - a global question, with no basket context
   * 
   * `COMPANY` - a company-specific question, related to what is purchased by the customer
   *
   * @return string
   */
  public function getScope()
  {
    return $this->scope;
  }


  /**
   * The available options to consent to for this question
   *
   * @return \Red61\Via\DataObject\ViaApiConsentOption[]
   */
  public function getConsentOptions()
  {
	return $this->consentOptions ? : array();
  }


  /**
   * List of companies this question is to be asked on behalf of
   *
   * @return \Red61\Via\DataObject\ViaApiCompany[]
   */
  public function getCompanies()
  {
	return $this->companies ? : array();
  }


}
