<?php
/**
 * Defines the RawapiGetHPHPerformancesRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Returns a list of the HPH performances
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetHPHPerformancesRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetHPHPerformancesRequest.
 */
abstract class RawapiGetHPHPerformancesRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetHPHPerformances';

  /**
   * 
   *
   * @var string
   */
  protected $concessionCode;

  /**
   * The start of the search window
   *
   * @var string
   */
  protected $startTime;

  /**
   * The end of the search window
   *
   * @var string
   */
  protected $endTime;

  /**
   * the server of the allocation
   *
   * @var int
   */
  protected $serverId;

  /**
   * The main role of the allocation
   *
   * @var int
   */
  protected $mainRoleId;

  /**
   * The role of the allocation
   *
   * @var int
   */
  protected $roleId;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * 
   *
   * @return string
   */
  public function getConcessionCode()
  {
    return $this->concessionCode;
  }


  /**
   * 
   *
   * @param string $concessionCode
   *
   * @return $this
   */
  public function setConcessionCode($concessionCode)
  {
    $this->concessionCode = $concessionCode;
    return $this;
  }

  /**
   * The start of the search window
   *
   * @return string
   */
  public function getStartTime()
  {
    return $this->startTime;
  }


  /**
   * The start of the search window
   *
   * @param string $startTime
   *
   * @return $this
   */
  public function setStartTime($startTime)
  {
    $this->startTime = $startTime;
    return $this;
  }

  /**
   * The end of the search window
   *
   * @return string
   */
  public function getEndTime()
  {
    return $this->endTime;
  }


  /**
   * The end of the search window
   *
   * @param string $endTime
   *
   * @return $this
   */
  public function setEndTime($endTime)
  {
    $this->endTime = $endTime;
    return $this;
  }

  /**
   * the server of the allocation
   *
   * @return int
   */
  public function getServerId()
  {
    return $this->serverId;
  }


  /**
   * the server of the allocation
   *
   * @param int $serverId
   *
   * @return $this
   */
  public function setServerId($serverId)
  {
    $this->serverId = $serverId;
    return $this;
  }

  /**
   * The main role of the allocation
   *
   * @return int
   */
  public function getMainRoleId()
  {
    return $this->mainRoleId;
  }


  /**
   * The main role of the allocation
   *
   * @param int $mainRoleId
   *
   * @return $this
   */
  public function setMainRoleId($mainRoleId)
  {
    $this->mainRoleId = $mainRoleId;
    return $this;
  }

  /**
   * The role of the allocation
   *
   * @return int
   */
  public function getRoleId()
  {
    return $this->roleId;
  }


  /**
   * The role of the allocation
   *
   * @param int $roleId
   *
   * @return $this
   */
  public function setRoleId($roleId)
  {
    $this->roleId = $roleId;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
