<?php
/**
 * Defines apiAddTicketsToBasketRequestSpec - specifications for Red61\Via\ApiRequest\apiAddTicketsToBasketRequest
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via\ApiRequest;

use PhpSpec\Exception\Example\FailureException;
use Red61\Via\DataObject\ViaApiTicketRequest;
use Red61\Via\Exception\ClientInvalidRequestException;
use spec\ObjectBehavior;
use Prophecy\Argument;

/**
 *
 * @see Red61\Via\ApiRequest\apiAddTicketsToBasketRequest
 */
class apiAddTicketsToBasketRequestSpec extends ObjectBehavior
{
    /**
     * Use $this->subject to get proper type hinting for the subject class
     * @var \Red61\Via\ApiRequest\apiAddTicketsToBasketRequest
     */
	protected $subject;

	function it_is_initializable()
    {
		$this->subject->shouldHaveType('Red61\Via\ApiRequest\apiAddTicketsToBasketRequest');
	}

	function it_is_a_lazy_basket_creating_request()
	{
		$this->subject->shouldHaveType('Red61\Via\ApiRequest\LazyBasketCreatingRequest');
	}

	function it_is_a_preflight_filtering_request()
	{
		$this->subject->shouldHaveType('Red61\Via\ApiRequest\PreflightFilteringRequest');
	}

	/**
	 * @param \Red61\Via\Plugin\ViaApiCallNotification  $notification
	 * @param \Red61\Via\DataObject\ViaApiTicketRequest $request
	 */
	function it_does_not_throw_preflight_with_ticket_list($notification, $request)
	{
		$this->subject->setTicketsList(array($request))->onBeforeViaCall($notification);
	}

	/**
	 * @param \Red61\Via\Plugin\ViaApiCallNotification $notification
	 *
	 * @throws \PhpSpec\Exception\Example\FailureException
	 */
	function it_throws_preflight_if_ticket_list_empty($notification)
	{
		try {
			$this->subject->setTicketsList(array())->onBeforeViaCall($notification);
			throw new FailureException("Expected exception not thrown");
		} catch (ClientInvalidRequestException $e)
		{
			expect($e->getInvalidParameters())->toHaveKey('ticketsList');
		}
	}

}
