<?php
/**
 * Defines the RawViaApiInsuranceQuoteDetails data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * 
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiInsuranceQuoteDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiInsuranceQuoteDetails.
 */
#[\AllowDynamicProperties]
abstract class RawViaApiInsuranceQuoteDetails {

  /**
   * Hash of the basket at the time the quote was calculated.
   *
   * @var string
   */
  protected $hash;

  /**
   * Quote reference supplied by the insurance provider.
   *
   * @var string
   */
  protected $quoteReference;

  /**
   * Price of supplied quote.
   *
   * @var double
   */
  protected $price;

  /**
   * Sales message to display from insurance provider.
   *
   * @var string
   */
  protected $salesMessage;

  /**
   * Terms and conditions of the supplied quote from the insurance provider.
   *
   * @var string
   */
  protected $termsAndConditions;

  /**
   * The name of the insurance provider for the quote.
   *
   * @var string
   */
  protected $insuranceProviderName;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'hash':
        return $this->getHash();
      case 'quoteReference':
        return $this->getQuoteReference();
      case 'price':
        return $this->getPrice();
      case 'salesMessage':
        return $this->getSalesMessage();
      case 'termsAndConditions':
        return $this->getTermsAndConditions();
      case 'insuranceProviderName':
        return $this->getInsuranceProviderName();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * Hash of the basket at the time the quote was calculated.
   *
   * @return string
   */
  public function getHash()
  {
    return $this->hash;
  }


  /**
   * Quote reference supplied by the insurance provider.
   *
   * @return string
   */
  public function getQuoteReference()
  {
    return $this->quoteReference;
  }


  /**
   * Price of supplied quote.
   *
   * @return double
   */
  public function getPrice()
  {
    return $this->price;
  }


  /**
   * Sales message to display from insurance provider.
   *
   * @return string
   */
  public function getSalesMessage()
  {
    return $this->salesMessage;
  }


  /**
   * Terms and conditions of the supplied quote from the insurance provider.
   *
   * @return string
   */
  public function getTermsAndConditions()
  {
    return $this->termsAndConditions;
  }


  /**
   * The name of the insurance provider for the quote.
   *
   * @return string
   */
  public function getInsuranceProviderName()
  {
    return $this->insuranceProviderName;
  }


}
