<?php
/**
 * Defines the RawapiCreateCardPaymentOrderRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Creates the initial order record and provides html for display to allow the Payment Service Provider to capture the
 * card details. Card Details are captured and send directly to the Payment Service Provider, so this method may be used
 * to provide solution where website hosting does not need to be PCI:DSS complaint
 * 
 * NOTE: Must call `apiSetDeliveryOption` before calling this method.
 * 
 * After `ViaApiCardPaymentRequest#paymentFormHTML` has been displayed and payment has been taken call
 * `apiSendCardPaymentReturn` to complete the order.
 * 
 * If the payment fails then this method can be called again and will prepare a new payment against the original order
 * for processing. Remember to only proceed to `apiSendCardPaymentReturn` if this method returns a populated
 * `ViaApiCardPaymentRequest#paymentFormHTML`
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiCreateCardPaymentOrderRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiCreateCardPaymentOrderRequest.
 */
abstract class RawapiCreateCardPaymentOrderRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiCreateCardPaymentOrder';

  /**
   * the webserver hostname making this payment if available
   *
   * @var string
   */
  protected $workstationId;

  /**
   * ID representing the customer making this payment
   *
   * @var int
   */
  protected $customerId;

  /**
   * URL the payment processor should to redirect to after a successful payment (if supported), Typically this page
   * would also make the call to `apiSendCardPaymentReturn`
   *
   * @var string
   */
  protected $successURL;

  /**
   * URL the payment processor should to redirect to after a failed payment (if supported), Typically this page would
   * also make the call to `apiSendCardPaymentReturn`
   *
   * @var string
   */
  protected $failURL;

  /**
   * Browser and device information required for 3DS
   *
   * @var \Red61\Via\DataObject\ViaApiThreeDSecureV2BrowserInfo
   */
  protected $api3DSecureV2BrowserInfo;

  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * the webserver hostname making this payment if available
   *
   * @return string
   */
  public function getWorkstationId()
  {
    return $this->workstationId;
  }


  /**
   * the webserver hostname making this payment if available
   *
   * @param string $workstationId
   *
   * @return $this
   */
  public function setWorkstationId($workstationId)
  {
    $this->workstationId = $workstationId;
    return $this;
  }

  /**
   * ID representing the customer making this payment
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * ID representing the customer making this payment
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * URL the payment processor should to redirect to after a successful payment (if supported), Typically this page
   * would also make the call to `apiSendCardPaymentReturn`
   *
   * @return string
   */
  public function getSuccessURL()
  {
    return $this->successURL;
  }


  /**
   * URL the payment processor should to redirect to after a successful payment (if supported), Typically this page
   * would also make the call to `apiSendCardPaymentReturn`
   *
   * @param string $successURL
   *
   * @return $this
   */
  public function setSuccessURL($successURL)
  {
    $this->successURL = $successURL;
    return $this;
  }

  /**
   * URL the payment processor should to redirect to after a failed payment (if supported), Typically this page would
   * also make the call to `apiSendCardPaymentReturn`
   *
   * @return string
   */
  public function getFailURL()
  {
    return $this->failURL;
  }


  /**
   * URL the payment processor should to redirect to after a failed payment (if supported), Typically this page would
   * also make the call to `apiSendCardPaymentReturn`
   *
   * @param string $failURL
   *
   * @return $this
   */
  public function setFailURL($failURL)
  {
    $this->failURL = $failURL;
    return $this;
  }

  /**
   * Browser and device information required for 3DS
   *
   * @return \Red61\Via\DataObject\ViaApiThreeDSecureV2BrowserInfo
   */
  public function getApi3DSecureV2BrowserInfo()
  {
    return $this->api3DSecureV2BrowserInfo;
  }


  /**
   * Browser and device information required for 3DS
   *
   * @param \Red61\Via\DataObject\ViaApiThreeDSecureV2BrowserInfo $api3DSecureV2BrowserInfo
   *
   * @return $this
   */
  public function setApi3DSecureV2BrowserInfo($api3DSecureV2BrowserInfo)
  {
    $this->api3DSecureV2BrowserInfo = $api3DSecureV2BrowserInfo;
    return $this;
  }

  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
