<?php
/**
 * Defines the RawapiMarkVoucherAsGiftedRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Marks the voucher for the specified order and line item as "gifted"
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiMarkVoucherAsGiftedRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiMarkVoucherAsGiftedRequest.
 */
abstract class RawapiMarkVoucherAsGiftedRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiMarkVoucherAsGifted';

  /**
   * Order to which you wish to add transaction notes, in format 'serverId:orderId'
   *
   * @var string
   */
  protected $orderId;

  /**
   * the Item Id of the voucher you wish to mark as gifted
   *
   * @var int
   */
  protected $voucherLineItemId;

  /**
   * The value of the note desired on the transaction
   *
   * @var string
   */
  protected $orderNote;

  /**
   * The authentication code
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * Order to which you wish to add transaction notes, in format 'serverId:orderId'
   *
   * @return string
   */
  public function getOrderId()
  {
    return $this->orderId;
  }


  /**
   * Order to which you wish to add transaction notes, in format 'serverId:orderId'
   *
   * @param string $orderId
   *
   * @return $this
   */
  public function setOrderId($orderId)
  {
    $this->orderId = $orderId;
    return $this;
  }

  /**
   * the Item Id of the voucher you wish to mark as gifted
   *
   * @return int
   */
  public function getVoucherLineItemId()
  {
    return $this->voucherLineItemId;
  }


  /**
   * the Item Id of the voucher you wish to mark as gifted
   *
   * @param int $voucherLineItemId
   *
   * @return $this
   */
  public function setVoucherLineItemId($voucherLineItemId)
  {
    $this->voucherLineItemId = $voucherLineItemId;
    return $this;
  }

  /**
   * The value of the note desired on the transaction
   *
   * @return string
   */
  public function getOrderNote()
  {
    return $this->orderNote;
  }


  /**
   * The value of the note desired on the transaction
   *
   * @param string $orderNote
   *
   * @return $this
   */
  public function setOrderNote($orderNote)
  {
    $this->orderNote = $orderNote;
    return $this;
  }

  /**
   * The authentication code
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
