<?php
/**
 * Defines the RawapiGetInsuranceQuotesForBasketRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method fetches the available insurance quotes for the current basket contents.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetInsuranceQuotesForBasketRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetInsuranceQuotesForBasketRequest.
 */
abstract class RawapiGetInsuranceQuotesForBasketRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiGetInsuranceQuotesForBasket';

  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
