<?php
/**
 * Defines apiGetBasketSuggestedDonationsRequestSpec - specifications for Red61\Via\ApiRequest\apiGetBasketSuggestedDonationsRequest
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via\ApiRequest;

use spec\ObjectBehavior;
use Prophecy\Argument;

/**
 *
 * @see Red61\Via\ApiRequest\apiGetBasketSuggestedDonationsRequest
 */
class apiGetBasketSuggestedDonationsRequestSpec extends ObjectBehavior
{
    /**
     * Use $this->subject to get proper type hinting for the subject class
     * @var \Red61\Via\ApiRequest\apiGetBasketSuggestedDonationsRequest
     */
	protected $subject;

	function it_is_initializable()
    {
		$this->subject->shouldHaveType('Red61\Via\ApiRequest\apiGetBasketSuggestedDonationsRequest');
	}

	function it_is_a_preflight_filtering_request()
	{
		$this->subject->shouldHaveType('Red61\Via\ApiRequest\PreflightFilteringRequest');
	}

	/**
	 * @param \Red61\Via\Plugin\ViaApiCallNotification $notification
	 */
	function its_preflight_does_nothing_if_basket_id($notification)
	{
		$this->subject->setSessionId('123123213')->onBeforeViaCall($notification);
		$notification->skipCallAndReturn(Argument::any())->shouldNotHaveBeenCalled();
	}


	/**
	 * @param \Red61\Via\Plugin\ViaApiCallNotification $notification
	 */
	function its_preflight_sets_canned_empty_basket_items_response_if_no_basket_id($notification)
	{
		$this->subject->onBeforeViaCall($notification);
		$notification->skipCallAndReturn(array())->shouldHaveBeenCalled();
	}
}
