<?php
/**
 * Defines the RawapiRemovePerformanceAccessNotesFromBasketRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Removes access note from the specified performances in the basket identified by `sessionId`.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiRemovePerformanceAccessNotesFromBasketRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiRemovePerformanceAccessNotesFromBasketRequest.
 */
abstract class RawapiRemovePerformanceAccessNotesFromBasketRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiRemovePerformanceAccessNotesFromBasket';

  /**
   * An array of perfKeys of the form "serverId:performanceId".
   *
   * @var string[]
   */
  protected $performanceRefs;

  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * The authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * An array of perfKeys of the form "serverId:performanceId".
   *
   * @return string[]
   */
  public function getPerformanceRefs()
  {
    return $this->performanceRefs;
  }


  /**
   * An array of perfKeys of the form "serverId:performanceId".
   *
   * @param string[] $performanceRefs
   *
   * @return $this
   */
  public function setPerformanceRefs($performanceRefs)
  {
    $this->performanceRefs = $performanceRefs;
    return $this;
  }

  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * The authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
