<?php
/**
 * Defines the RawapiCreateMediaRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Method requests an AWS pre-signed URL and a media ID from the back end. The front end then uploads the image to the
 * AWS URL and any subsequent requests to retrieve that image with the media ID should respond with the URL to fetch it
 * from AWS.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiCreateMediaRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiCreateMediaRequest.
 */
abstract class RawapiCreateMediaRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiCreateMedia';

  /**
   * - the size of the file in bytes
   *
   * @var int
   */
  protected $fileSize;

  /**
   * - the MIME type of the file
   *
   * @var string
   */
  protected $mimeType;

  /**
   * - the authentication code to use
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * - the size of the file in bytes
   *
   * @return int
   */
  public function getFileSize()
  {
    return $this->fileSize;
  }


  /**
   * - the size of the file in bytes
   *
   * @param int $fileSize
   *
   * @return $this
   */
  public function setFileSize($fileSize)
  {
    $this->fileSize = $fileSize;
    return $this;
  }

  /**
   * - the MIME type of the file
   *
   * @return string
   */
  public function getMimeType()
  {
    return $this->mimeType;
  }


  /**
   * - the MIME type of the file
   *
   * @param string $mimeType
   *
   * @return $this
   */
  public function setMimeType($mimeType)
  {
    $this->mimeType = $mimeType;
    return $this;
  }

  /**
   * - the authentication code to use
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * - the authentication code to use
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
