<?php
/**
 * Defines the RawViaApiTicketItemDetails data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Represents a single ticket within a group of tickets `ViaApiTicketDetails`
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiTicketItemDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiTicketItemDetails.
 */
abstract class RawViaApiTicketItemDetails {

  /**
   * The ticketId for this ticket in this transaction
   *
   * @var int
   */
  protected $ticketId;

  /**
   * The itemId for this ticket in this transaction
   *
   * @var int
   */
  protected $itemId;

  /**
   * The barcode for this ticket
   *
   * @var string
   */
  protected $barcode;

  /**
   * The status of this ticket within it's reservation. Possible values are:
   * 
   * - **Pending** : active within this reservation. Can be converted or released.
   * - **Converted** : has been converted.
   * - **Refunded** : has been converted and then refunded.
   * - **Cancelled** : has been released from the reservation.
   * 
   * Note: field is `null` if ticket is not part of a reservation
   *
   * @var string
   */
  protected $reservationStatus;

  /**
   * The amount of this ticket that is applicable for gift aid
   *
   * @var double
   */
  protected $giftAidDonation;

  /**
   * The tax value for this ticket. This is included in the ticket price `ViaApiTicketDetails#price`
   *
   * @var double
   */
  protected $taxValue;

  /**
   * Whether this ticket item is a wheelchair space one or not. (true / false)
   *
   * @var bool
   */
  protected $isWheelchairSpaceTicket;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'ticketId':
        return $this->getTicketId();
      case 'itemId':
        return $this->getItemId();
      case 'barcode':
        return $this->getBarcode();
      case 'reservationStatus':
        return $this->getReservationStatus();
      case 'giftAidDonation':
        return $this->getGiftAidDonation();
      case 'taxValue':
        return $this->getTaxValue();
      case 'isWheelchairSpaceTicket':
        return $this->getIsWheelchairSpaceTicket();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The ticketId for this ticket in this transaction
   *
   * @return int
   */
  public function getTicketId()
  {
    return $this->ticketId;
  }


  /**
   * The itemId for this ticket in this transaction
   *
   * @return int
   */
  public function getItemId()
  {
    return $this->itemId;
  }


  /**
   * The barcode for this ticket
   *
   * @return string
   */
  public function getBarcode()
  {
    return $this->barcode;
  }


  /**
   * The status of this ticket within it's reservation. Possible values are:
   * 
   * - **Pending** : active within this reservation. Can be converted or released.
   * - **Converted** : has been converted.
   * - **Refunded** : has been converted and then refunded.
   * - **Cancelled** : has been released from the reservation.
   * 
   * Note: field is `null` if ticket is not part of a reservation
   *
   * @return string
   */
  public function getReservationStatus()
  {
    return $this->reservationStatus;
  }


  /**
   * The amount of this ticket that is applicable for gift aid
   *
   * @return double
   */
  public function getGiftAidDonation()
  {
    return $this->giftAidDonation;
  }


  /**
   * The tax value for this ticket. This is included in the ticket price `ViaApiTicketDetails#price`
   *
   * @return double
   */
  public function getTaxValue()
  {
    return $this->taxValue;
  }


  /**
   * Whether this ticket item is a wheelchair space one or not. (true / false)
   *
   * @return bool
   */
  public function getIsWheelchairSpaceTicket()
  {
    return $this->isWheelchairSpaceTicket;
  }


}
