<?php
/**
 * Defines the RawapiSaveCardDetailsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Saves a customer's card without having to process an order and to allow the card details be saved for future
 * purchases. Only available if the Payment Provider supports this functionality.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiSaveCardDetailsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiSaveCardDetailsRequest.
 */
abstract class RawapiSaveCardDetailsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiSaveCardDetails';

  /**
   * the card holder's name.
   *
   * @var string
   */
  protected $ccName;

  /**
   * the Primary Account Number without spaces.
   *
   * @var string
   */
  protected $ccNumber;

  /**
   * start date of the form "MM/YY" if available.
   *
   * @var string
   */
  protected $startDate;

  /**
   * expiry date of the form "MM/YY" if available.
   *
   * @var string
   */
  protected $expiryDate;

  /**
   * issue number if available.
   *
   * @var string
   */
  protected $issue;

  /**
   * the security number on the back of the card.
   *
   * @var string
   */
  protected $cv2;

  /**
   * ID representing the customer saving a card
   *
   * @var int
   */
  protected $customerId;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * the card holder's name.
   *
   * @return string
   */
  public function getCcName()
  {
    return $this->ccName;
  }


  /**
   * the card holder's name.
   *
   * @param string $ccName
   *
   * @return $this
   */
  public function setCcName($ccName)
  {
    $this->ccName = $ccName;
    return $this;
  }

  /**
   * the Primary Account Number without spaces.
   *
   * @return string
   */
  public function getCcNumber()
  {
    return $this->ccNumber;
  }


  /**
   * the Primary Account Number without spaces.
   *
   * @param string $ccNumber
   *
   * @return $this
   */
  public function setCcNumber($ccNumber)
  {
    $this->ccNumber = $ccNumber;
    return $this;
  }

  /**
   * start date of the form "MM/YY" if available.
   *
   * @return string
   */
  public function getStartDate()
  {
    return $this->startDate;
  }


  /**
   * start date of the form "MM/YY" if available.
   *
   * @param string $startDate
   *
   * @return $this
   */
  public function setStartDate($startDate)
  {
    $this->startDate = $startDate;
    return $this;
  }

  /**
   * expiry date of the form "MM/YY" if available.
   *
   * @return string
   */
  public function getExpiryDate()
  {
    return $this->expiryDate;
  }


  /**
   * expiry date of the form "MM/YY" if available.
   *
   * @param string $expiryDate
   *
   * @return $this
   */
  public function setExpiryDate($expiryDate)
  {
    $this->expiryDate = $expiryDate;
    return $this;
  }

  /**
   * issue number if available.
   *
   * @return string
   */
  public function getIssue()
  {
    return $this->issue;
  }


  /**
   * issue number if available.
   *
   * @param string $issue
   *
   * @return $this
   */
  public function setIssue($issue)
  {
    $this->issue = $issue;
    return $this;
  }

  /**
   * the security number on the back of the card.
   *
   * @return string
   */
  public function getCv2()
  {
    return $this->cv2;
  }


  /**
   * the security number on the back of the card.
   *
   * @param string $cv2
   *
   * @return $this
   */
  public function setCv2($cv2)
  {
    $this->cv2 = $cv2;
    return $this;
  }

  /**
   * ID representing the customer saving a card
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * ID representing the customer saving a card
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
