<?php
/**
 * Defines the RawapiApplyInsuranceToBasketRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method applies the selected insurance quote against the current basket.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiApplyInsuranceToBasketRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiApplyInsuranceToBasketRequest.
 */
abstract class RawapiApplyInsuranceToBasketRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiApplyInsuranceToBasket';

  /**
   * The selected insurance quote
   *
   * @var \Red61\Via\DataObject\ViaApiInsuranceQuoteDetails
   */
  protected $insuranceQuoteDetails;

  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The selected insurance quote
   *
   * @return \Red61\Via\DataObject\ViaApiInsuranceQuoteDetails
   */
  public function getInsuranceQuoteDetails()
  {
    return $this->insuranceQuoteDetails;
  }


  /**
   * The selected insurance quote
   *
   * @param \Red61\Via\DataObject\ViaApiInsuranceQuoteDetails $insuranceQuoteDetails
   *
   * @return $this
   */
  public function setInsuranceQuoteDetails($insuranceQuoteDetails)
  {
    $this->insuranceQuoteDetails = $insuranceQuoteDetails;
    return $this;
  }

  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
