<?php
/**
 * Defines ViaApiAddressDetailsSpec - specifications for Red61\Via\DataObject\ViaApiAddressDetails
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via\DataObject;

use spec\ObjectBehavior;
use Prophecy\Argument;

/**
 *
 * @see Red61\Via\DataObject\ViaApiAddressDetails
 */
class ViaApiAddressDetailsSpec extends ObjectBehavior
{
    /**
     * Use $this->subject to get proper type hinting for the subject class
     * @var \Red61\Via\DataObject\ViaApiAddressDetails
     */
	protected $subject;

	function it_is_initializable()
    {
		$this->subject->shouldHaveType('Red61\Via\DataObject\ViaApiAddressDetails');
	}

	function it_can_be_constructed_with_address_for_use_in_search_request()
	{
		$this->beConstructedWith('address1', 'address2', 'address3', 'county', 'country', 'postcode');
		$this->subject->getAddress1()->shouldBe('address1');
		$this->subject->getAddress2()->shouldBe('address2');
		$this->subject->getAddress3()->shouldBe('address3');
		$this->subject->getCounty()->shouldBe('county');
		$this->subject->getCountry()->shouldBe('country');
		$this->subject->getPostcode()->shouldBe('postcode');
	}
}
