<?php
/**
 * Defines the RawapiGetSubVenuesRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Gets the sub venues visible or sub venues of the venue if specified, using the supplied authorisation code `webKey`.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetSubVenuesRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetSubVenuesRequest.
 */
abstract class RawapiGetSubVenuesRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetSubVenues';

  /**
   * The serverId and venueId of the venue to list sub venues for. in form 'serverId:venueId'. If '0:0' is passed in the
   * it will list all subvenues, not specific to a venue
   *
   * @var string
   */
  protected $venueRef;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The serverId and venueId of the venue to list sub venues for. in form 'serverId:venueId'. If '0:0' is passed in the
   * it will list all subvenues, not specific to a venue
   *
   * @return string
   */
  public function getVenueRef()
  {
    return $this->venueRef;
  }


  /**
   * The serverId and venueId of the venue to list sub venues for. in form 'serverId:venueId'. If '0:0' is passed in the
   * it will list all subvenues, not specific to a venue
   *
   * @param string $venueRef
   *
   * @return $this
   */
  public function setVenueRef($venueRef)
  {
    $this->venueRef = $venueRef;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
