<?php
/**
* Defines the BasketIdNotSet exception
*
* @author    Red61 Ltd
* @copyright Red61 Ltd
* @licence   proprietary
*/

namespace Red61\Via\Exception;
use Red61\Via\ApiRequest\BasketIdRequiredRequest;

/**
 * Thrown if a BasketIdRequiredRequest is attempted before a basket ID has been set
 *
 * [!!] This exception extends \SoapFault for legacy compatibility reasons, but is likely
 *      in future to change to extend \BadMethodCallException or a similar runtime exception
 *      class.
 *
 *
 * @see \Red61\Via\ViaApiClient::send
 * @see \Red61\Via\ApiRequest\BasketIdRequiredRequest
 */
class BasketIdNotSetException extends \SoapFault implements ViaException {

	/**
	 * @var \Red61\Via\ApiRequest\BasketIdRequiredRequest
	 */
	protected $attemptedRequest;

	/**
	 * @param BasketIdRequiredRequest $attemptedRequest
	 */
	public function __construct(BasketIdRequiredRequest $attemptedRequest)
	{
		$this->attemptedRequest = $attemptedRequest;
		parent::__construct(
			'Client',
			'Could not send a '.get_class($attemptedRequest).' request because the VIA Basket Id was not set'
		);
	}

	/**
	 * The API request that was attempted
	 *
	 * @return BasketIdRequiredRequest
	 */
	public function getAttemptedRequest()
	{
		return $this->attemptedRequest;
	}

}
