<?php
/**
 * Defines the apiCreateAccountRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\ApiRequest;
use Red61\Via\DataObject\ViaApiCustomerDetails;
use Red61\Via\Exception\ClientInvalidRequestException;
use Red61\Via\Plugin\ViaApiCallNotification;

/**
 * @package    Red61\Via\ApiRequest
 * {@inheritdoc}
 */
class apiCreateAccountRequest
	extends \Red61\Via\RawGenerated\ApiRequest\RawapiCreateAccountRequest
	implements PreflightFilteringRequest {

	/**
	 * Prepares a request for updating a customer's existing record based on their current details. Use this if you want
	 * to update just a few properties of the customer record to be sure that you don't overwrite any existing optional
	 * values.
	 *
	 * @param ViaApiCustomerDetails $customer_details
	 *
	 * @return apiCreateAccountRequest
	 */
	public static function createFromCustomer(ViaApiCustomerDetails $customer_details)
	{
		$request = new static;
		/** @var apiCreateAccountRequest $request */
		$request->setCreate(FALSE)
			->setCustomerId($customer_details->getCustomerid())
			->setTitle($customer_details->getTitle())
			->setForename($customer_details->getFirstname())
			->setSurname($customer_details->getSurname())
			->setCompany($customer_details->getCompany())
			->setAddress1($customer_details->getStreet1())
			->setAddress2($customer_details->getStreet2())
			->setAddress3($customer_details->getStreet3())
			->setCity($customer_details->getCity())
			->setCounty($customer_details->getCounty())
			->setCountry($customer_details->getCountry())
			->setPostcode($customer_details->getPostcode())
			->setDayPhone($customer_details->getOtherdetails()->getDayphone())
			->setEveningPhone($customer_details->getOtherdetails()->getEvephone())
			->setMobile($customer_details->getOtherdetails()->getMobile())
			->setEmail($customer_details->getOtherdetails()->getEmail())
			->setPreferredContactMethod($customer_details->getOtherdetails()->getPrefcontact())
			->setOrganisationMailingPermission($customer_details->getOrganisation_mailing())
			->setThirdPartyMailingPermission($customer_details->getThirdparty_mailing())
			->setAdditionalMailingPermission($customer_details->getAdditional_mailing());
		return $request;
	}

	/**
	 * Perform some action - validation, canned response or initialisation - immediately before the request is sent
	 *
	 * @param ViaApiCallNotification $notification
	 *
	 * @throws \Red61\Via\Exception\ClientInvalidRequestException
	 * @return void
	 */
	public function onBeforeViaCall(ViaApiCallNotification $notification)
	{
		$errors = $this->buildEmptyFieldErrorsFor(array('surname', 'email'));

		$create  = $this->getCreate();
		$cust_id = $this->getCustomerId();

		if ($create AND ($cust_id !== 0)) {
			$errors['customerId'] = 'You must set customerId to 0 to create a new account';
		} else if ( ! $create AND ! $cust_id) {
			$errors['customerId'] = 'You must set customerId to update a customer account';
		}

		if (strlen($this->getSurname()) < 1) {
			$errors['surname'] = 'Surname must be at least one character';
		}

		if ($errors) {
			throw new ClientInvalidRequestException($this, $errors);
		}
	}

	/**
	 * Trims the value before setting
	 *
	 * {@inheritdoc}
	 */
	public function setPreferredContactMethod($preferredContactMethod)
	{
		return parent::setPreferredContactMethod(trim($preferredContactMethod));
	}

	/**
	 * Trims the value before setting
	 *
	 * {@inheritdoc}
	 */
	public function setEmail($email)
	{
		return parent::setEmail(trim($email));
	}

	/**
	 * Trims the value before setting
	 *
	 * {@inheritdoc}
	 */
	public function setForename($forename)
	{
		return parent::setForename(trim($forename));
	}

	/**
	 * Trims the value before setting
	 *
	 * {@inheritdoc}
	 */
	public function setSurname($surname)
	{
		return parent::setSurname(trim($surname));
	}

}
