<?php
/**
 * Defines the RawViaApiPerformanceConcession data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores the details of a concession that is applied at the performance level.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiPerformanceConcession.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiPerformanceConcession.
 */
abstract class RawViaApiPerformanceConcession {

  /**
   * The concession code.
   *
   * @var string
   */
  protected $code;

  /**
   * The concession description.
   *
   * @var string
   */
  protected $description;

  /**
   * The concession title.
   *
   * @var string
   */
  protected $title;

  /**
   * The reference of the scheme this concession is a member of if any. In the form "serverId:schemeId".
   *
   * @var string
   */
  protected $scheme_ref;

  /**
   * See {@link #type}.
   *
   * @var int
   */
  protected $required_qty;

  /**
   * The value of this concession.
   *
   * @var double
   */
  protected $fixed_value;

  /**
   * The "mode" of this concession, Mode determines how the {@link #fixed_value} of this concession will be applied.
   * <ul>
   * <li>0	- Percentage	- The new price is price * fixed_value (i.e. Price of £10 and 0.5 fixed value gives £5).
   * <li>1	- Amount		- The new price has amount added. (i.e. Price of £10 and -2 fixed value gives £8).
   * <li>2	- Fixed amount	- The new price is simply the value (i.e. Price of £10 and fixed value of 7 gives £7).
   * </ul>
   *
   * @var int
   */
  protected $mode;

  /**
   * True if this concession is limited to a certain amount.
   *
   * @var bool
   */
  protected $limited;

  /**
   * Specifies the behaviour of required qty.
   * <ul>
   * <li>0	- Multiple of		- In order to receive this concession the number of tickets with this concession must be a
   * multiple of {@link #required_qty}.
   * <li>1	- Minimum Quantity	- In order to receive this concession the number of tickets with this concession must be
   * at least {@link #required_qty}.
   * </ul>
   *
   * @var int
   */
  protected $type;

  /**
   * The value that this concession is limited to
   * if this concession is limited to a certain amount.
   *
   * @var int
   */
  protected $limitValue;

  /**
   * An estimate of the remaining number of
   * applications this concession can have.
   *
   * @var int
   */
  protected $remainingLimitValue;

  /**
   * The Key of the ticket offer relating to this concession in the form serverId:PC:performanceConcessionId.
   *
   * @var string
   */
  protected $ticketOfferKey;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'code':
        return $this->getCode();
      case 'description':
        return $this->getDescription();
      case 'title':
        return $this->getTitle();
      case 'scheme_ref':
        return $this->getScheme_ref();
      case 'required_qty':
        return $this->getRequired_qty();
      case 'fixed_value':
        return $this->getFixed_value();
      case 'mode':
        return $this->getMode();
      case 'limited':
        return $this->getLimited();
      case 'type':
        return $this->getType();
      case 'limitValue':
        return $this->getLimitValue();
      case 'remainingLimitValue':
        return $this->getRemainingLimitValue();
      case 'ticketOfferKey':
        return $this->getTicketOfferKey();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The concession code.
   *
   * @return string
   */
  public function getCode()
  {
    return $this->code;
  }


  /**
   * The concession description.
   *
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }


  /**
   * The concession title.
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The reference of the scheme this concession is a member of if any. In the form "serverId:schemeId".
   *
   * @return string
   */
  public function getScheme_ref()
  {
    return $this->scheme_ref;
  }


  /**
   * See {@link #type}.
   *
   * @return int
   */
  public function getRequired_qty()
  {
    return $this->required_qty;
  }


  /**
   * The value of this concession.
   *
   * @return double
   */
  public function getFixed_value()
  {
    return $this->fixed_value;
  }


  /**
   * The "mode" of this concession, Mode determines how the {@link #fixed_value} of this concession will be applied.
   * <ul>
   * <li>0	- Percentage	- The new price is price * fixed_value (i.e. Price of £10 and 0.5 fixed value gives £5).
   * <li>1	- Amount		- The new price has amount added. (i.e. Price of £10 and -2 fixed value gives £8).
   * <li>2	- Fixed amount	- The new price is simply the value (i.e. Price of £10 and fixed value of 7 gives £7).
   * </ul>
   *
   * @return int
   */
  public function getMode()
  {
    return $this->mode;
  }


  /**
   * True if this concession is limited to a certain amount.
   *
   * @return bool
   */
  public function getLimited()
  {
    return $this->limited;
  }


  /**
   * Specifies the behaviour of required qty.
   * <ul>
   * <li>0	- Multiple of		- In order to receive this concession the number of tickets with this concession must be a
   * multiple of {@link #required_qty}.
   * <li>1	- Minimum Quantity	- In order to receive this concession the number of tickets with this concession must be
   * at least {@link #required_qty}.
   * </ul>
   *
   * @return int
   */
  public function getType()
  {
    return $this->type;
  }


  /**
   * The value that this concession is limited to
   * if this concession is limited to a certain amount.
   *
   * @return int
   */
  public function getLimitValue()
  {
    return $this->limitValue;
  }


  /**
   * An estimate of the remaining number of
   * applications this concession can have.
   *
   * @return int
   */
  public function getRemainingLimitValue()
  {
    return $this->remainingLimitValue;
  }


  /**
   * The Key of the ticket offer relating to this concession in the form serverId:PC:performanceConcessionId.
   *
   * @return string
   */
  public function getTicketOfferKey()
  {
    return $this->ticketOfferKey;
  }


}
