<?php
/**
 * Defines the RawViaApiCustomerDetails data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores the details of a particular customer.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiCustomerDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiCustomerDetails.
 */
abstract class RawViaApiCustomerDetails {

  /**
   * The id of this customer.
   *
   * @var int
   */
  protected $customerid;

  /**
   * The customer number of this customer.
   *
   * @var string
   */
  protected $customernumber;

  /**
   * The membership number of this customer. Unused.
   *
   * @var string
   */
  protected $membershipnumber;

  /**
   * The title of this customer.
   *
   * @var string
   */
  protected $title;

  /**
   * The first name of this customer.
   *
   * @var string
   */
  protected $firstname;

  /**
   * The middle initial of this customer.
   *
   * @var string
   */
  protected $initial;

  /**
   * The surname of this customer.
   *
   * @var string
   */
  protected $surname;

  /**
   * The first line of this customers address.
   *
   * @var string
   */
  protected $street1;

  /**
   * The second line of this customers address.
   *
   * @var string
   */
  protected $street2;

  /**
   * The third line of this customers address.
   *
   * @var string
   */
  protected $street3;

  /**
   * The city of this customers address.
   *
   * @var string
   */
  protected $city;

  /**
   * The county of this customers address.
   *
   * @var string
   */
  protected $county;

  /**
   * The country of this customers address.
   *
   * @var string
   */
  protected $country;

  /**
   * The po box of this customers address.
   *
   * @var string
   */
  protected $poBox;

  /**
   * The state of this customers address.
   *
   * @var string
   */
  protected $state;

  /**
   * The postcode of this customers address.
   *
   * @var string
   */
  protected $postcode;

  /**
   * The customers marketing score. Unused.
   *
   * @var double
   */
  protected $score;

  /**
   * Any notes on this customer.
   *
   * @var string
   */
  protected $notes;

  /**
   * The friend status of this customer. Unused.
   *
   * @var bool
   */
  protected $friend;

  /**
   * Whether this customer has allowed permission to be contacted by this organisation.
   *
   * @var bool
   */
  protected $organisation_mailing;

  /**
   * Whether this customer has allowed permission to be contacted by this third parties.
   *
   * @var bool
   */
  protected $thirdparty_mailing;

  /**
   * Whether this customer has allowed permission to be contacted by additional sources, such as companies and
   * organisations.
   *
   * @var bool
   */
  protected $additional_mailing;

  /**
   * Whether or not this customer has an active gift aid declaration.
   *
   * @var bool
   */
  protected $donation_gift_aid;

  /**
   * This customers other details.
   * This contains extra information on the customer.
   *
   * @var \Red61\Via\DataObject\ViaApiCustomerOtherDetails
   */
  protected $otherdetails;

  /**
   * The date this customer record was created.
   *
   * @var \DateTime
   */
  protected $dateCreated;

  /**
   * The last date this customer record was updated.
   *
   * @var \DateTime
   */
  protected $dateUpdated;

  /**
   * The Id of the customer that this account has been
   * merged into. This will be null if no merging has taken place.
   *
   * @var int
   */
  protected $merged_to_customer_id;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'customerid':
        return $this->getCustomerid();
      case 'customernumber':
        return $this->getCustomernumber();
      case 'membershipnumber':
        return $this->getMembershipnumber();
      case 'title':
        return $this->getTitle();
      case 'firstname':
        return $this->getFirstname();
      case 'initial':
        return $this->getInitial();
      case 'surname':
        return $this->getSurname();
      case 'street1':
        return $this->getStreet1();
      case 'street2':
        return $this->getStreet2();
      case 'street3':
        return $this->getStreet3();
      case 'city':
        return $this->getCity();
      case 'county':
        return $this->getCounty();
      case 'country':
        return $this->getCountry();
      case 'poBox':
        return $this->getPoBox();
      case 'state':
        return $this->getState();
      case 'postcode':
        return $this->getPostcode();
      case 'score':
        return $this->getScore();
      case 'notes':
        return $this->getNotes();
      case 'friend':
        return $this->getFriend();
      case 'organisation_mailing':
        return $this->getOrganisation_mailing();
      case 'thirdparty_mailing':
        return $this->getThirdparty_mailing();
      case 'additional_mailing':
        return $this->getAdditional_mailing();
      case 'donation_gift_aid':
        return $this->getDonation_gift_aid();
      case 'otherdetails':
        return $this->getOtherdetails();
      case 'dateCreated':
        return $this->getDateCreated();
      case 'dateUpdated':
        return $this->getDateUpdated();
      case 'merged_to_customer_id':
        return $this->getMerged_to_customer_id();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The id of this customer.
   *
   * @return int
   */
  public function getCustomerid()
  {
    return $this->customerid;
  }


  /**
   * The customer number of this customer.
   *
   * @return string
   */
  public function getCustomernumber()
  {
    return $this->customernumber;
  }


  /**
   * The membership number of this customer. Unused.
   *
   * @return string
   */
  public function getMembershipnumber()
  {
    return $this->membershipnumber;
  }


  /**
   * The title of this customer.
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The first name of this customer.
   *
   * @return string
   */
  public function getFirstname()
  {
    return $this->firstname;
  }


  /**
   * The middle initial of this customer.
   *
   * @return string
   */
  public function getInitial()
  {
    return $this->initial;
  }


  /**
   * The surname of this customer.
   *
   * @return string
   */
  public function getSurname()
  {
    return $this->surname;
  }


  /**
   * The first line of this customers address.
   *
   * @return string
   */
  public function getStreet1()
  {
    return $this->street1;
  }


  /**
   * The second line of this customers address.
   *
   * @return string
   */
  public function getStreet2()
  {
    return $this->street2;
  }


  /**
   * The third line of this customers address.
   *
   * @return string
   */
  public function getStreet3()
  {
    return $this->street3;
  }


  /**
   * The city of this customers address.
   *
   * @return string
   */
  public function getCity()
  {
    return $this->city;
  }


  /**
   * The county of this customers address.
   *
   * @return string
   */
  public function getCounty()
  {
    return $this->county;
  }


  /**
   * The country of this customers address.
   *
   * @return string
   */
  public function getCountry()
  {
    return $this->country;
  }


  /**
   * The po box of this customers address.
   *
   * @return string
   */
  public function getPoBox()
  {
    return $this->poBox;
  }


  /**
   * The state of this customers address.
   *
   * @return string
   */
  public function getState()
  {
    return $this->state;
  }


  /**
   * The postcode of this customers address.
   *
   * @return string
   */
  public function getPostcode()
  {
    return $this->postcode;
  }


  /**
   * The customers marketing score. Unused.
   *
   * @return double
   */
  public function getScore()
  {
    return $this->score;
  }


  /**
   * Any notes on this customer.
   *
   * @return string
   */
  public function getNotes()
  {
    return $this->notes;
  }


  /**
   * The friend status of this customer. Unused.
   *
   * @return bool
   */
  public function getFriend()
  {
    return $this->friend;
  }


  /**
   * Whether this customer has allowed permission to be contacted by this organisation.
   *
   * @return bool
   */
  public function getOrganisation_mailing()
  {
    return $this->organisation_mailing;
  }


  /**
   * Whether this customer has allowed permission to be contacted by this third parties.
   *
   * @return bool
   */
  public function getThirdparty_mailing()
  {
    return $this->thirdparty_mailing;
  }


  /**
   * Whether this customer has allowed permission to be contacted by additional sources, such as companies and
   * organisations.
   *
   * @return bool
   */
  public function getAdditional_mailing()
  {
    return $this->additional_mailing;
  }


  /**
   * Whether or not this customer has an active gift aid declaration.
   *
   * @return bool
   */
  public function getDonation_gift_aid()
  {
    return $this->donation_gift_aid;
  }


  /**
   * This customers other details.
   * This contains extra information on the customer.
   *
   * @return \Red61\Via\DataObject\ViaApiCustomerOtherDetails
   */
  public function getOtherdetails()
  {
    return $this->otherdetails;
  }


  /**
   * The date this customer record was created.
   *
   * @return \DateTime
   */
  public function getDateCreated()
  {
    return $this->dateCreated;
  }


  /**
   * The last date this customer record was updated.
   *
   * @return \DateTime
   */
  public function getDateUpdated()
  {
    return $this->dateUpdated;
  }


  /**
   * The Id of the customer that this account has been
   * merged into. This will be null if no merging has taken place.
   *
   * @return int
   */
  public function getMerged_to_customer_id()
  {
    return $this->merged_to_customer_id;
  }


}
