<?php
/**
 * Defines the RawViaApiBasketEventItem data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores the information on a event for which there are tickets in the basket.
 * This class contains a list of {@link ViaApiBasketPerformanceItem} for which there are tickets in the basket.
 * These objects contain the {@link ViaApiProductDetails} objects
 * which contain the information on actual tickets.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiBasketEventItem.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiBasketEventItem.
 */
abstract class RawViaApiBasketEventItem {

  /**
   * The reference for this event of the form "serverId:eventId".
   *
   * @var string
   */
  protected $eventid;

  /**
   * The name of this event
   *
   * @var string
   */
  protected $name;

  /**
   * The title of this events company
   *
   * @var string
   */
  protected $company;

  /**
   * The title of this events promoter.
   *
   * @var string
   */
  protected $promoter;

  /**
   * A list of {@link ViaApiBasketPerformanceItem} containing details of the performances for which there are tickets in
   * the basket.
   *
   * @var \Red61\Via\DataObject\ViaApiBasketPerformanceItem[]
   */
  protected $performances;

  /**
   * The event's venue
   *
   * @var \Red61\Via\DataObject\ViaApiBasketVenueItem
   */
  protected $venue;

  /**
   * The event's subvenue
   *
   * @var \Red61\Via\DataObject\ViaApiBasketSubVenueItem
   */
  protected $subvenue;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'eventid':
        return $this->getEventid();
      case 'name':
        return $this->getName();
      case 'company':
        return $this->getCompany();
      case 'promoter':
        return $this->getPromoter();
      case 'performances':
        return $this->getPerformances();
      case 'venue':
        return $this->getVenue();
      case 'subvenue':
        return $this->getSubvenue();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The reference for this event of the form "serverId:eventId".
   *
   * @return string
   */
  public function getEventid()
  {
    return $this->eventid;
  }


  /**
   * The name of this event
   *
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }


  /**
   * The title of this events company
   *
   * @return string
   */
  public function getCompany()
  {
    return $this->company;
  }


  /**
   * The title of this events promoter.
   *
   * @return string
   */
  public function getPromoter()
  {
    return $this->promoter;
  }


  /**
   * A list of {@link ViaApiBasketPerformanceItem} containing details of the performances for which there are tickets in
   * the basket.
   *
   * @return \Red61\Via\DataObject\ViaApiBasketPerformanceItem[]
   */
  public function getPerformances()
  {
	return $this->performances ? : array();
  }


  /**
   * The event's venue
   *
   * @return \Red61\Via\DataObject\ViaApiBasketVenueItem
   */
  public function getVenue()
  {
    return $this->venue;
  }


  /**
   * The event's subvenue
   *
   * @return \Red61\Via\DataObject\ViaApiBasketSubVenueItem
   */
  public function getSubvenue()
  {
    return $this->subvenue;
  }


}
