<?php
/**
 * Defines the RawapiUpdateCustomerOtherDetailsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Updates the customer's extended details returned by apiGetCustomerDetails
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiUpdateCustomerOtherDetailsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiUpdateCustomerOtherDetailsRequest.
 */
abstract class RawapiUpdateCustomerOtherDetailsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiUpdateCustomerOtherDetails';

  /**
   * The id of the customer to update the details of.
   *
   * @var int
   */
  protected $customerId;

  /**
   * A {@link ViaApiCustomerOtherDetails} object containing the new details, {@link #apiGetCustomerDetails(int,
   * java.lang.String) } can be used to get the current details.
   *
   * @var \Red61\Via\DataObject\ViaApiCustomerOtherDetails
   */
  protected $apiOtherDetails;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The id of the customer to update the details of.
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The id of the customer to update the details of.
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * A {@link ViaApiCustomerOtherDetails} object containing the new details, {@link #apiGetCustomerDetails(int,
   * java.lang.String) } can be used to get the current details.
   *
   * @return \Red61\Via\DataObject\ViaApiCustomerOtherDetails
   */
  public function getApiOtherDetails()
  {
    return $this->apiOtherDetails;
  }


  /**
   * A {@link ViaApiCustomerOtherDetails} object containing the new details, {@link #apiGetCustomerDetails(int,
   * java.lang.String) } can be used to get the current details.
   *
   * @param \Red61\Via\DataObject\ViaApiCustomerOtherDetails $apiOtherDetails
   *
   * @return $this
   */
  public function setApiOtherDetails($apiOtherDetails)
  {
    $this->apiOtherDetails = $apiOtherDetails;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
