<?php
/**
 * Defines the RawapiUpdateCustomerCustomFieldsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Updates the given customers custom fields based on the given entries.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiUpdateCustomerCustomFieldsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiUpdateCustomerCustomFieldsRequest.
 */
abstract class RawapiUpdateCustomerCustomFieldsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiUpdateCustomerCustomFields';

  /**
   * The customer to update
   *
   * @var int
   */
  protected $customerId;

  /**
   * An array of {@link ViaApiCustomCustomerFieldDetails} objects containing the new entry or the newly selected choice.
   *
   * @var \Red61\Via\DataObject\ViaApiCustomCustomerFieldDetails[]
   */
  protected $entries;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The customer to update
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The customer to update
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * An array of {@link ViaApiCustomCustomerFieldDetails} objects containing the new entry or the newly selected choice.
   *
   * @return \Red61\Via\DataObject\ViaApiCustomCustomerFieldDetails[]
   */
  public function getEntries()
  {
    return $this->entries;
  }


  /**
   * An array of {@link ViaApiCustomCustomerFieldDetails} objects containing the new entry or the newly selected choice.
   *
   * @param \Red61\Via\DataObject\ViaApiCustomCustomerFieldDetails[] $entries
   *
   * @return $this
   */
  public function setEntries($entries)
  {
    $this->entries = $entries;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
