<?php
/**
 * Defines the RawapiUpdateCustomerCompanyMailPermissionsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method is used to update the customer's mailing permissions  to include the new responses given.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiUpdateCustomerCompanyMailPermissionsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiUpdateCustomerCompanyMailPermissionsRequest.
 */
abstract class RawapiUpdateCustomerCompanyMailPermissionsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiUpdateCustomerCompanyMailPermissions';

  /**
   * The List of ViaApiCustomerCompanyResponse objects containing the company id in the form "companyServerId:companyId"
   * and containing a Boolean value indicating if the customer wishes to be contacted by the company. Note: a NULL value
   * for the Boolean indicates that the customer did not select a choice.
   *
   * @var \Red61\Via\DataObject\ViaApiCustomerCompanyResponse[]
   */
  protected $customerCompanyResponses;

  /**
   * The Id of the customer to update.
   *
   * @var int
   */
  protected $customerId;

  /**
   * The authentication code to use
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The List of ViaApiCustomerCompanyResponse objects containing the company id in the form "companyServerId:companyId"
   * and containing a Boolean value indicating if the customer wishes to be contacted by the company. Note: a NULL value
   * for the Boolean indicates that the customer did not select a choice.
   *
   * @return \Red61\Via\DataObject\ViaApiCustomerCompanyResponse[]
   */
  public function getCustomerCompanyResponses()
  {
    return $this->customerCompanyResponses;
  }


  /**
   * The List of ViaApiCustomerCompanyResponse objects containing the company id in the form "companyServerId:companyId"
   * and containing a Boolean value indicating if the customer wishes to be contacted by the company. Note: a NULL value
   * for the Boolean indicates that the customer did not select a choice.
   *
   * @param \Red61\Via\DataObject\ViaApiCustomerCompanyResponse[] $customerCompanyResponses
   *
   * @return $this
   */
  public function setCustomerCompanyResponses($customerCompanyResponses)
  {
    $this->customerCompanyResponses = $customerCompanyResponses;
    return $this;
  }

  /**
   * The Id of the customer to update.
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The Id of the customer to update.
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The authentication code to use
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
