<?php
/**
 * Defines the RawapiSetCustomerCategoriesRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Set the customer categories of this customer
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiSetCustomerCategoriesRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiSetCustomerCategoriesRequest.
 */
abstract class RawapiSetCustomerCategoriesRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiSetCustomerCategories';

  /**
   * The id of the customer
   *
   * @var int
   */
  protected $customerId;

  /**
   * int array of category ids. These must correspond to web accessible customer categories ids.
   *
   * @var int[]
   */
  protected $categories;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The id of the customer
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The id of the customer
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * int array of category ids. These must correspond to web accessible customer categories ids.
   *
   * @return int[]
   */
  public function getCategories()
  {
    return $this->categories;
  }


  /**
   * int array of category ids. These must correspond to web accessible customer categories ids.
   *
   * @param int[] $categories
   *
   * @return $this
   */
  public function setCategories($categories)
  {
    $this->categories = $categories;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
