<?php
/**
 * Defines the RawapiRemoveMerchandiseFromBasketRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Removes the given quantity of the given merchandise from the basket.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiRemoveMerchandiseFromBasketRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiRemoveMerchandiseFromBasketRequest.
 */
abstract class RawapiRemoveMerchandiseFromBasketRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiRemoveMerchandiseFromBasket';

  /**
   * The merchandise variation to remove in the form "serverId:merchandiseVariationId"
   *
   * @var string
   */
  protected $merchandiseVariationRef;

  /**
   * The quantity to remove from the basket.
   *
   * @var int
   */
  protected $qty;

  /**
   * The ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The merchandise variation to remove in the form "serverId:merchandiseVariationId"
   *
   * @return string
   */
  public function getMerchandiseVariationRef()
  {
    return $this->merchandiseVariationRef;
  }


  /**
   * The merchandise variation to remove in the form "serverId:merchandiseVariationId"
   *
   * @param string $merchandiseVariationRef
   *
   * @return $this
   */
  public function setMerchandiseVariationRef($merchandiseVariationRef)
  {
    $this->merchandiseVariationRef = $merchandiseVariationRef;
    return $this;
  }

  /**
   * The quantity to remove from the basket.
   *
   * @return int
   */
  public function getQty()
  {
    return $this->qty;
  }


  /**
   * The quantity to remove from the basket.
   *
   * @param int $qty
   *
   * @return $this
   */
  public function setQty($qty)
  {
    $this->qty = $qty;
    return $this;
  }

  /**
   * The ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * The ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
