<?php
/**
 * Defines the RawapiIsPostAllowedRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Checks to see that the earliest performance in the shopping basket is  outwith the post cut off time.
 * <code>cutoff</code> is not currently  stored in the db so is hardcoded and stored within session management. It  is
 * used to decide whether to give the customer the option of having there  tickets posted to them.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiIsPostAllowedRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiIsPostAllowedRequest.
 */
abstract class RawapiIsPostAllowedRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiIsPostAllowed';

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * number of days before the earliest performance in the basket that post is still an option
   *
   * @var int
   */
  protected $cutoff;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * number of days before the earliest performance in the basket that post is still an option
   *
   * @return int
   */
  public function getCutoff()
  {
    return $this->cutoff;
  }


  /**
   * number of days before the earliest performance in the basket that post is still an option
   *
   * @param int $cutoff
   *
   * @return $this
   */
  public function setCutoff($cutoff)
  {
    $this->cutoff = $cutoff;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
