<?php
/**
 * Defines the RawapiGetSchemeDetailsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Returns the details for a particular scheme<br>  ViaApiSchemeDetails contains a nested array of
 * ViaApiSchemeTierDetails objects
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetSchemeDetailsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetSchemeDetailsRequest.
 */
abstract class RawapiGetSchemeDetailsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetSchemeDetails';

  /**
   * The reference for the scheme, of the form serverid:schemeid
   *
   * @var string
   */
  protected $schemeRef;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The reference for the scheme, of the form serverid:schemeid
   *
   * @return string
   */
  public function getSchemeRef()
  {
    return $this->schemeRef;
  }


  /**
   * The reference for the scheme, of the form serverid:schemeid
   *
   * @param string $schemeRef
   *
   * @return $this
   */
  public function setSchemeRef($schemeRef)
  {
    $this->schemeRef = $schemeRef;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
