<?php
/**
 * Defines the RawapiGetPerformanceDetailsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Gets details about a given performance.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetPerformanceDetailsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetPerformanceDetailsRequest.
 */
abstract class RawapiGetPerformanceDetailsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetPerformanceDetails';

  /**
   * The id of the performance to return details for in the form 'serverId:performanceId'
   *
   * @var string
   */
  protected $performanceRef;

  /**
   * the authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The id of the performance to return details for in the form 'serverId:performanceId'
   *
   * @return string
   */
  public function getPerformanceRef()
  {
    return $this->performanceRef;
  }


  /**
   * The id of the performance to return details for in the form 'serverId:performanceId'
   *
   * @param string $performanceRef
   *
   * @return $this
   */
  public function setPerformanceRef($performanceRef)
  {
    $this->performanceRef = $performanceRef;
    return $this;
  }

  /**
   * the authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * the authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
