<?php
/**
 * Defines the RawapiClearBasketRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Clears any items from the current basket (such as tickets and schemes).  This sets any seats in the basket back on
 * sale. If an order has been  created line items are deleted too and any remote inventory server records relating to
 * the order. If {@code removeBasket} is {@code true}, it removes the basket so the {@code sessionId} is no longer valid
 * after this call has succeeded.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiClearBasketRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiClearBasketRequest.
 */
abstract class RawapiClearBasketRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiClearBasket';

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * Whether the basket identified by the {@code sessionId} should be destroyed, invalidating the {@code sessionId}
   *
   * @var bool
   */
  protected $removeBasket;

  /**
   * The authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * Whether the basket identified by the {@code sessionId} should be destroyed, invalidating the {@code sessionId}
   *
   * @return bool
   */
  public function getRemoveBasket()
  {
    return $this->removeBasket;
  }


  /**
   * Whether the basket identified by the {@code sessionId} should be destroyed, invalidating the {@code sessionId}
   *
   * @param bool $removeBasket
   *
   * @return $this
   */
  public function setRemoveBasket($removeBasket)
  {
    $this->removeBasket = $removeBasket;
    return $this;
  }

  /**
   * The authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
