<?php
/**
 * Defines the RawapiClaimFromFriendRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method is used to claim the items that have had a token generated for them using {@link
 * #apiSendToAFriend(java.util.Set, java.lang.String, java.lang.String) }
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiClaimFromFriendRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiClaimFromFriendRequest.
 */
abstract class RawapiClaimFromFriendRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiClaimFromFriend';

  /**
   * the token used to claim the items
   *
   * @var string
   */
  protected $token;

  /**
   * The ID of the transaction that the items to claim are from
   *
   * @var string
   */
  protected $orderId;

  /**
   * The ID of the customer that is claiming the items.
   *
   * @var int
   */
  protected $customerId;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * the token used to claim the items
   *
   * @return string
   */
  public function getToken()
  {
    return $this->token;
  }


  /**
   * the token used to claim the items
   *
   * @param string $token
   *
   * @return $this
   */
  public function setToken($token)
  {
    $this->token = $token;
    return $this;
  }

  /**
   * The ID of the transaction that the items to claim are from
   *
   * @return string
   */
  public function getOrderId()
  {
    return $this->orderId;
  }


  /**
   * The ID of the transaction that the items to claim are from
   *
   * @param string $orderId
   *
   * @return $this
   */
  public function setOrderId($orderId)
  {
    $this->orderId = $orderId;
    return $this;
  }

  /**
   * The ID of the customer that is claiming the items.
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The ID of the customer that is claiming the items.
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
