<?php
/**
* Defines the ViaSoapFault exception
*
* @author    Red61 Ltd
* @copyright 2014 Red61 Ltd
* @licence   proprietary
*/

namespace Red61\Via\Exception;


/**
 * Thrown if a SoapFault is thrown during a VIA request (or SoapClient creation) and the exception
 * does not map to a more specific expected exception type.
 *
 * This will include network problems, VIA downtime, and server-side issues but may also include
 * validation and related errors that have not yet been mapped to specific types - so you should
 * not assume that this exception type indicates a server-side problem.
 *
 * We hope in future API versions to introduce more specific exception classes and reduce the use
 * of this to only cover unexpected cases.
 *
 *
 * @see \Red61\Via\Exception\ViaExceptionMaper::map
 */
class ViaSoapFault extends \SoapFault implements ViaException { }
