<?php
/**
 * Defines the ViaApiCustomCustomerFieldDetails VIA data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\DataObject;
use Red61\Via\ViaApiClient;

/**
 * @package    Red61\Via\DataObject
 * {@inheritdoc}
 */
class ViaApiCustomCustomerFieldDetails extends \Red61\Via\RawGenerated\DataObject\RawViaApiCustomCustomerFieldDetails {

	/**
	 * Set a new value for this entry (not valid if this is a CHOICE field).
	 *
	 * You will then need to store this updated customer data with ViaApiService::updateCustomerCustomFields
	 *
	 * @param string $entry
	 *
	 * @return $this
	 * @see \Red61\Via\ViaApiService::updateCustomerCustomFields
	 */
	public function setEntry($entry)
	{
		$this->entry = $entry;
		return $this;
	}

	/**
	 * Set a new selected choice for this field - only valid if this is a CHOICE field.
	 *
	 * You will then need to store this updated customer data with ViaApiService::updateCustomerCustomFields

	 * @param int $selectedChoice
	 *
	 * @return $this
	 */
	public function setSelectedChoice($selectedChoice)
	{
		$this->selectedChoice = $selectedChoice;
		return $this;
	}

	/**
	 * Provides access to protected response properties in backwards compatible mode.
	 *
	 * Direct property access is deprecated, with setter access preferred for new projects. This method bridges the gap,
	 * optionally logging any last property access in a project. For new code or once an existing application is migrated,
	 * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
	 *
	 * @param string $field the property to set
	 * @param mixed  $value the value to set
	 *
	 * @return void
	 * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
	 */
	public function __set($field, $value) {
		$prop = sprintf('%s->%s', get_class($this), $field);
		if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
			throw new \BadMethodCallException(
				'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
				'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
			);
		}

		if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
			trigger_error(
				'Property '.$prop.' should not be accessed directly, use the getter method instead',
				E_USER_NOTICE
			);
		}

		switch ($field)
		{
			case 'entry':
				$this->setEntry($value);
			break;

			case 'selectedChoice':
				$this->setSelectedChoice($value);
			break;

			default:
				parent::__set($field, $value);
		}
	}


}
