<?php
/**
 * Finds the methods of a class
 *
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 */

namespace spec\Support;


use PhpSpec\Wrapper\SubjectContainerInterface;

/**
 * Finds all methods of an object for use with asserting that values are set
 *
 * @package spec\Support
 */
class SubjectMethodFinder {

	/**
	 * @var object
	 */
	protected $object;

	/**
	 * @var \ReflectionClass
	 */
	protected $reflection;

	/**
	 * @param \PhpSpec\Wrapper\SubjectContainerInterface $subject
	 *
	 * @return static
	 */
	public static function for_subject(SubjectContainerInterface $subject)
	{
		return new static($subject->getWrappedObject());
	}

	/**
	 * @param object $object
	 */
	public function __construct($object)
	{
		$this->object = $object;
		$this->reflection = new \ReflectionClass($object);
	}

	/**
	 * @return string[]
	 */
	public function find_getters()
	{
		$getters = array();
		foreach ($this->reflection->getMethods(\ReflectionMethod::IS_PUBLIC) as $method) {
			$name = $method->getName();
			if (substr($name, 0, 3) === 'get') {
				$getters[] = $name;
			}
		}
		return $getters;
	}
}
