<?php
/**
 * Defines the apiSetAffiliateRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\ApiRequest;

/**
 * @package    Red61\Via\ApiRequest
 * {@inheritdoc}
 */
class apiSetAffiliateRequest
	extends \Red61\Via\RawGenerated\ApiRequest\RawapiSetAffiliateRequest
	implements LazyBasketMetadataSettingRequest {

	/**
	 * Sets the value, truncating to 50 characters
	 * {@inheritdoc}
	 */
	public function setAffiliateCode($affiliateCode)
	{
		return parent::setAffiliateCode(substr($affiliateCode, 0, 50));
	}

	/**
	 * Sets the value, truncating to 125 characters
	 * {@inheritdoc}
	 */
	public function setAffiliateToken($token)
	{
		$token = substr($token, 0, 125);
		return parent::setAffiliateToken(substr($token, 0, 125));
	}

}
