<?php
/**
 * Defines the RawapiGetSeatingPlanRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method creates an xml document from which a seating plan can be rendered. It can also return only the seats that
 * have recently changed to facilitate seating plan refreshing
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetSeatingPlanRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetSeatingPlanRequest.
 */
abstract class RawapiGetSeatingPlanRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdOptionalRequest {


  const SOAP_METHOD_NAME = 'apiGetSeatingPlan';

  /**
   * The reference for the performance of the form "serverId:performanceId"
   *
   * @var string
   */
  protected $performanceRef;

  /**
   * The unix timestamp of the last loading of the xml,
   *
   * @var double
   */
  protected $lastUpdate;

  /**
   * The current basket id (if one has been created). Allows for seats already selected by this user to be highlighted
   *
   * @var string
   */
  protected $sessionId;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The reference for the performance of the form "serverId:performanceId"
   *
   * @return string
   */
  public function getPerformanceRef()
  {
    return $this->performanceRef;
  }


  /**
   * The reference for the performance of the form "serverId:performanceId"
   *
   * @param string $performanceRef
   *
   * @return $this
   */
  public function setPerformanceRef($performanceRef)
  {
    $this->performanceRef = $performanceRef;
    return $this;
  }

  /**
   * The unix timestamp of the last loading of the xml,
   *
   * @return double
   */
  public function getLastUpdate()
  {
    return $this->lastUpdate;
  }


  /**
   * The unix timestamp of the last loading of the xml,
   *
   * @param double $lastUpdate
   *
   * @return $this
   */
  public function setLastUpdate($lastUpdate)
  {
    $this->lastUpdate = $lastUpdate;
    return $this;
  }

  /**
   * The current basket id (if one has been created). Allows for seats already selected by this user to be highlighted
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * The current basket id (if one has been created). Allows for seats already selected by this user to be highlighted
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
