<?php
/**
 * Defines the PreflightFilteringRequest interface
 *
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\ApiRequest;
use Red61\Via\Plugin\ViaApiCallNotification;


/**
 * Request objects implementing this interface will be given the chance to perform operations just before they are sent to the VIA API.
 *
 * For example, you might want to:
 *
 * * initialise a request parameter if it hasn't been set yet
 * * throw an exception if the request parameters are invalid (perhaps a required id or email address is missing)
 * * return a canned response in some cases (for example, an empty basket summary if there is no basket ID)
 *
 * [!!] Requests that are skipped or throw errors during preflight will never be dispatched into the plugin queue -
 *      so will not trigger ON_CALL_SUCCESS or ON_CALL_FAILED handlers. This interface is therefore most appropriate for
 *      lightweight cases that should really be considered validation or invalid state of the application itself. If you
 *      need to perform custom processing but still trigger the normal event dispatch cycle you should instead implement
 *      a plugin.
 *
 * @package Red61\Via\ApiRequest
 */
interface PreflightFilteringRequest {

	/**
	 * Perform some action - validation, canned response or initialisation - immediately before the request is sent
	 *
	 * @param ViaApiCallNotification $notification
	 *
	 * @return void
	 */
	public function onBeforeViaCall(ViaApiCallNotification $notification);
}
