<?php
/**
 * Defines the RawViaApiTransactionDetails data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Contains the details of a transaction. `products` is different to `ViaApiPurchaseSummary#products`
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiTransactionDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiTransactionDetails.
 */
abstract class RawViaApiTransactionDetails {

  /**
   * The reference of this order in the form "serverId:orderId"
   *
   * @var string
   */
  protected $orderid;

  /**
   * The reference of the order being refunded if `type` is `Refund`. In the form "serverId:orderId"
   *
   * @var string
   */
  protected $refundedOrderId;

  /**
   * The reference of the order being exchanged. In the form "serverId:orderId". `null` if this transaction is NOT an
   * exchange
   *
   * @var string
   */
  protected $exchangedOrderId;

  /**
   * The title of this order.
   *
   * @var string
   */
  protected $ordertitle;

  /**
   * The date of this order in the form "yyyy-MM-dd HH:mm:ss". See the `java.text.SimpleDateFormat` documentation for
   * information on this format.
   *
   * @var string
   */
  protected $date;

  /**
   * The total value of this order.
   *
   * @var string
   */
  protected $total;

  /**
   * The order subtotal. This is the sum of all basket items.
   *
   * @var string
   */
  protected $subtotal;

  /**
   * The handling fee amount applied to this order
   *
   * @var string
   */
  protected $orderFee;

  /**
   * The fee total. This is order fee + postage fee.
   *
   * @var string
   */
  protected $feeTotal;

  /**
   * 
   *
   * @var string
   */
  protected $discount;

  /**
   * 
   *
   * @var string
   */
  protected $currency;

  /**
   * 
   *
   * @var bool
   */
  protected $post;

  /**
   * the printOption values may be: NOW, COBO, POST, RESERVED, ISSUED, NA, NONE or ETICKET
   *
   * @var string
   */
  protected $printOption;

  /**
   * The postage fee amount applied to this order.
   *
   * @var string
   */
  protected $postagefee;

  /**
   * The name of the customer who made this order.
   *
   * @var string
   */
  protected $customername;

  /**
   * The id of the customer who made this order.
   *
   * @var int
   */
  protected $customerid;

  /**
   * The count of all items in the order including schemes, merchandise, purchased vouchers, tickets and donations.
   *
   * @var int
   */
  protected $itemcount;

  /**
   * The short form of the name of local tax, e.g VAT, GST
   *
   * @var string
   */
  protected $taxCode;

  /**
   * The total value of the tax applied to this basket
   *
   * @var string
   */
  protected $taxTotal;

  /**
   * The details of the schemes in this order.
   *
   * @var \Red61\Via\DataObject\ViaApiSchemeTierDetails[]
   */
  protected $schemes;

  /**
   * The details of the vouchers in this order.
   *
   * @var \Red61\Via\DataObject\ViaApiVoucherDetails[]
   */
  protected $vouchers;

  /**
   * The details of the donations in this order.
   *
   * @var \Red61\Via\DataObject\ViaApiDonationDetails[]
   */
  protected $donations;

  /**
   * The details of the merchandise in this order.
   *
   * @var \Red61\Via\DataObject\ViaApiMerchandiseDetails[]
   */
  protected $merchandise;

  /**
   * An array of `ViaApiTransactionEventFeeDetails` objects each containing information on an event fee that has been
   * applied to an event within this transaction. Note: field is NULL is no event fees have been applied
   *
   * @var \Red61\Via\DataObject\ViaApiTransactionEventFeeDetails[]
   */
  protected $eventFees;

  /**
   * An array of `ViaApiTransactionPaymentDetails` objects containing all successful payments for this transaction and
   * any refunds against this transaction
   *
   * @var \Red61\Via\DataObject\ViaApiTransactionPaymentDetails[]
   */
  protected $payments;

  /**
   * A url which points to a barcode for this order.
   *
   * @var string
   */
  protected $barcodeURL;

  /**
   * The type of this order. Usually "SALE" but may be "RESERVED".
   *
   * @var string
   */
  protected $type;

  /**
   * The details of the tickets in this order. Includes the `ViaApiTicketItemDetailsWithStatus#availableToScan`
   * information
   *
   * @var \Red61\Via\DataObject\ViaApiTicketDetailsWithStatus[]
   */
  protected $products;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'orderid':
        return $this->getOrderid();
      case 'refundedOrderId':
        return $this->getRefundedOrderId();
      case 'exchangedOrderId':
        return $this->getExchangedOrderId();
      case 'ordertitle':
        return $this->getOrdertitle();
      case 'date':
        return $this->getDate();
      case 'total':
        return $this->getTotal();
      case 'subtotal':
        return $this->getSubtotal();
      case 'orderFee':
        return $this->getOrderFee();
      case 'feeTotal':
        return $this->getFeeTotal();
      case 'discount':
        return $this->getDiscount();
      case 'currency':
        return $this->getCurrency();
      case 'post':
        return $this->getPost();
      case 'printOption':
        return $this->getPrintOption();
      case 'postagefee':
        return $this->getPostagefee();
      case 'customername':
        return $this->getCustomername();
      case 'customerid':
        return $this->getCustomerid();
      case 'itemcount':
        return $this->getItemcount();
      case 'taxCode':
        return $this->getTaxCode();
      case 'taxTotal':
        return $this->getTaxTotal();
      case 'schemes':
        return $this->getSchemes();
      case 'vouchers':
        return $this->getVouchers();
      case 'donations':
        return $this->getDonations();
      case 'merchandise':
        return $this->getMerchandise();
      case 'eventFees':
        return $this->getEventFees();
      case 'payments':
        return $this->getPayments();
      case 'barcodeURL':
        return $this->getBarcodeURL();
      case 'type':
        return $this->getType();
      case 'products':
        return $this->getProducts();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The reference of this order in the form "serverId:orderId"
   *
   * @return string
   */
  public function getOrderid()
  {
    return $this->orderid;
  }


  /**
   * The reference of the order being refunded if `type` is `Refund`. In the form "serverId:orderId"
   *
   * @return string
   */
  public function getRefundedOrderId()
  {
    return $this->refundedOrderId;
  }


  /**
   * The reference of the order being exchanged. In the form "serverId:orderId". `null` if this transaction is NOT an
   * exchange
   *
   * @return string
   */
  public function getExchangedOrderId()
  {
    return $this->exchangedOrderId;
  }


  /**
   * The title of this order.
   *
   * @return string
   */
  public function getOrdertitle()
  {
    return $this->ordertitle;
  }


  /**
   * The date of this order in the form "yyyy-MM-dd HH:mm:ss". See the `java.text.SimpleDateFormat` documentation for
   * information on this format.
   *
   * @return string
   */
  public function getDate()
  {
    return $this->date;
  }


  /**
   * The total value of this order.
   *
   * @return string
   */
  public function getTotal()
  {
    return $this->total;
  }


  /**
   * The order subtotal. This is the sum of all basket items.
   *
   * @return string
   */
  public function getSubtotal()
  {
    return $this->subtotal;
  }


  /**
   * The handling fee amount applied to this order
   *
   * @return string
   */
  public function getOrderFee()
  {
    return $this->orderFee;
  }


  /**
   * The fee total. This is order fee + postage fee.
   *
   * @return string
   */
  public function getFeeTotal()
  {
    return $this->feeTotal;
  }


  /**
   * 
   *
   * @return string
   */
  public function getDiscount()
  {
    return $this->discount;
  }


  /**
   * 
   *
   * @return string
   */
  public function getCurrency()
  {
    return $this->currency;
  }


  /**
   * 
   *
   * @return bool
   */
  public function getPost()
  {
    return $this->post;
  }


  /**
   * the printOption values may be: NOW, COBO, POST, RESERVED, ISSUED, NA, NONE or ETICKET
   *
   * @return string
   */
  public function getPrintOption()
  {
    return $this->printOption;
  }


  /**
   * The postage fee amount applied to this order.
   *
   * @return string
   */
  public function getPostagefee()
  {
    return $this->postagefee;
  }


  /**
   * The name of the customer who made this order.
   *
   * @return string
   */
  public function getCustomername()
  {
    return $this->customername;
  }


  /**
   * The id of the customer who made this order.
   *
   * @return int
   */
  public function getCustomerid()
  {
    return $this->customerid;
  }


  /**
   * The count of all items in the order including schemes, merchandise, purchased vouchers, tickets and donations.
   *
   * @return int
   */
  public function getItemcount()
  {
    return $this->itemcount;
  }


  /**
   * The short form of the name of local tax, e.g VAT, GST
   *
   * @return string
   */
  public function getTaxCode()
  {
    return $this->taxCode;
  }


  /**
   * The total value of the tax applied to this basket
   *
   * @return string
   */
  public function getTaxTotal()
  {
    return $this->taxTotal;
  }


  /**
   * The details of the schemes in this order.
   *
   * @return \Red61\Via\DataObject\ViaApiSchemeTierDetails[]
   */
  public function getSchemes()
  {
	return $this->schemes ? : array();
  }


  /**
   * The details of the vouchers in this order.
   *
   * @return \Red61\Via\DataObject\ViaApiVoucherDetails[]
   */
  public function getVouchers()
  {
	return $this->vouchers ? : array();
  }


  /**
   * The details of the donations in this order.
   *
   * @return \Red61\Via\DataObject\ViaApiDonationDetails[]
   */
  public function getDonations()
  {
	return $this->donations ? : array();
  }


  /**
   * The details of the merchandise in this order.
   *
   * @return \Red61\Via\DataObject\ViaApiMerchandiseDetails[]
   */
  public function getMerchandise()
  {
	return $this->merchandise ? : array();
  }


  /**
   * An array of `ViaApiTransactionEventFeeDetails` objects each containing information on an event fee that has been
   * applied to an event within this transaction. Note: field is NULL is no event fees have been applied
   *
   * @return \Red61\Via\DataObject\ViaApiTransactionEventFeeDetails[]
   */
  public function getEventFees()
  {
	return $this->eventFees ? : array();
  }


  /**
   * An array of `ViaApiTransactionPaymentDetails` objects containing all successful payments for this transaction and
   * any refunds against this transaction
   *
   * @return \Red61\Via\DataObject\ViaApiTransactionPaymentDetails[]
   */
  public function getPayments()
  {
	return $this->payments ? : array();
  }


  /**
   * A url which points to a barcode for this order.
   *
   * @return string
   */
  public function getBarcodeURL()
  {
    return $this->barcodeURL;
  }


  /**
   * The type of this order. Usually "SALE" but may be "RESERVED".
   *
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }


  /**
   * The details of the tickets in this order. Includes the `ViaApiTicketItemDetailsWithStatus#availableToScan`
   * information
   *
   * @return \Red61\Via\DataObject\ViaApiTicketDetailsWithStatus[]
   */
  public function getProducts()
  {
	return $this->products ? : array();
  }


}
