<?php
/**
 * Defines the RawapiCreateRepeatPaymentOrderRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * 
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiCreateRepeatPaymentOrderRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiCreateRepeatPaymentOrderRequest.
 */
abstract class RawapiCreateRepeatPaymentOrderRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiCreateRepeatPaymentOrder';

  /**
   * See `apiGetCustomerSavedCards`
   *
   * @var string
   */
  protected $repeatPaymentToken;

  /**
   * The expiry date of the form "MM/YY" if available.
   *
   * @var string
   */
  protected $expiryDate;

  /**
   * The security no on back of card.
   *
   * @var string
   */
  protected $cv2;

  /**
   * The webserver hostname making this payment if available. Note: max chars 20, so you may need to truncate
   *
   * @var string
   */
  protected $workstationId;

  /**
   * Set to be null if apiSetDeliveryOption has been used earlier. This value is for legacy compatibility
   * pre-deliveryOptions. `0` to indicate that the order will be collected at the box office, `1` to indicate that the
   * tickets will be posted out to the customers primary address, `2` to indicate that the tickets will be posted to the
   * customers alternative address.
   *
   * @var int
   */
  protected $deliveryOption;

  /**
   * The id of the customer making this payment. The id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var int
   */
  protected $customerId;

  /**
   * The id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * 3D secure required field, indicates the type of device used for the transaction, possible values are 0 for PC and 1
   * for mobile device.
   *
   * @var int
   */
  protected $browserType;

  /**
   * 3D secure required field, the user agent associated with the device.
   *
   * @var string
   */
  protected $userAgent;

  /**
   * 3D secure required field, The MIME types of the headers accepted by this device.
   *
   * @var string
   */
  protected $acceptHeaders;

  /**
   * The authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * See `apiGetCustomerSavedCards`
   *
   * @return string
   */
  public function getRepeatPaymentToken()
  {
    return $this->repeatPaymentToken;
  }


  /**
   * See `apiGetCustomerSavedCards`
   *
   * @param string $repeatPaymentToken
   *
   * @return $this
   */
  public function setRepeatPaymentToken($repeatPaymentToken)
  {
    $this->repeatPaymentToken = $repeatPaymentToken;
    return $this;
  }

  /**
   * The expiry date of the form "MM/YY" if available.
   *
   * @return string
   */
  public function getExpiryDate()
  {
    return $this->expiryDate;
  }


  /**
   * The expiry date of the form "MM/YY" if available.
   *
   * @param string $expiryDate
   *
   * @return $this
   */
  public function setExpiryDate($expiryDate)
  {
    $this->expiryDate = $expiryDate;
    return $this;
  }

  /**
   * The security no on back of card.
   *
   * @return string
   */
  public function getCv2()
  {
    return $this->cv2;
  }


  /**
   * The security no on back of card.
   *
   * @param string $cv2
   *
   * @return $this
   */
  public function setCv2($cv2)
  {
    $this->cv2 = $cv2;
    return $this;
  }

  /**
   * The webserver hostname making this payment if available. Note: max chars 20, so you may need to truncate
   *
   * @return string
   */
  public function getWorkstationId()
  {
    return $this->workstationId;
  }


  /**
   * The webserver hostname making this payment if available. Note: max chars 20, so you may need to truncate
   *
   * @param string $workstationId
   *
   * @return $this
   */
  public function setWorkstationId($workstationId)
  {
    $this->workstationId = $workstationId;
    return $this;
  }

  /**
   * Set to be null if apiSetDeliveryOption has been used earlier. This value is for legacy compatibility
   * pre-deliveryOptions. `0` to indicate that the order will be collected at the box office, `1` to indicate that the
   * tickets will be posted out to the customers primary address, `2` to indicate that the tickets will be posted to the
   * customers alternative address.
   *
   * @return int
   */
  public function getDeliveryOption()
  {
    return $this->deliveryOption;
  }


  /**
   * Set to be null if apiSetDeliveryOption has been used earlier. This value is for legacy compatibility
   * pre-deliveryOptions. `0` to indicate that the order will be collected at the box office, `1` to indicate that the
   * tickets will be posted out to the customers primary address, `2` to indicate that the tickets will be posted to the
   * customers alternative address.
   *
   * @param int $deliveryOption
   *
   * @return $this
   */
  public function setDeliveryOption($deliveryOption)
  {
    $this->deliveryOption = $deliveryOption;
    return $this;
  }

  /**
   * The id of the customer making this payment. The id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The id of the customer making this payment. The id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * The id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * 3D secure required field, indicates the type of device used for the transaction, possible values are 0 for PC and 1
   * for mobile device.
   *
   * @return int
   */
  public function getBrowserType()
  {
    return $this->browserType;
  }


  /**
   * 3D secure required field, indicates the type of device used for the transaction, possible values are 0 for PC and 1
   * for mobile device.
   *
   * @param int $browserType
   *
   * @return $this
   */
  public function setBrowserType($browserType)
  {
    $this->browserType = $browserType;
    return $this;
  }

  /**
   * 3D secure required field, the user agent associated with the device.
   *
   * @return string
   */
  public function getUserAgent()
  {
    return $this->userAgent;
  }


  /**
   * 3D secure required field, the user agent associated with the device.
   *
   * @param string $userAgent
   *
   * @return $this
   */
  public function setUserAgent($userAgent)
  {
    $this->userAgent = $userAgent;
    return $this;
  }

  /**
   * 3D secure required field, The MIME types of the headers accepted by this device.
   *
   * @return string
   */
  public function getAcceptHeaders()
  {
    return $this->acceptHeaders;
  }


  /**
   * 3D secure required field, The MIME types of the headers accepted by this device.
   *
   * @param string $acceptHeaders
   *
   * @return $this
   */
  public function setAcceptHeaders($acceptHeaders)
  {
    $this->acceptHeaders = $acceptHeaders;
    return $this;
  }

  /**
   * The authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
