<?php
/**
 * Defines the ViaApiBasket VIA data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\DataObject;
use \Red61\Via\ViaApiClient;

/**
 * @package    Red61\Via\DataObject
 * {@inheritdoc}
 */
class ViaApiBasket extends \Red61\Via\RawGenerated\DataObject\RawViaApiBasket {

	
	public function __get($field) {
		$prop = sprintf('%s->%s', get_class($this), $field);
		if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
			throw new \BadMethodCallException(
			'Property ' . $prop . ' is not accessible' . \PHP_EOL . \PHP_EOL .
			'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
			);
		}

		if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
			trigger_error(
					'Property ' . $prop . ' should not be accessed directly, use the getter method instead', E_USER_NOTICE
			);
		}
		switch ($field) {
			case 'voucherRedeams':
				return $this->getVoucherRedeems();
			default:
				return parent::__get($field);
		}
	}

}
