<?php
/**
 * Defines the RawCustomerMergedException base exception class
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\Exception;

use \Red61\Via\Exception\ViaException;

/**
 * Exception is used to indicate that a call has been made using a customer that is now merged into another customer
 * account.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\Exception\CustomerMergedException.
 *
 * @package    Red61\Via\RawGenerated\Exception
 * @see        \Red61\Via\Exception\CustomerMergedException.
 */
#[\AllowDynamicProperties]
abstract class RawCustomerMergedException extends \SoapFault implements ViaException {

  /**
   * 
   *
   * @var mixed
   */
  protected $reason;

  /**
   * 
   *
   * @var mixed
   */
  protected $mergedToCustomerId;


  public static function fromSoapFault(\SoapFault $fault)
  {
    $e = new static(
        $fault->faultcode,
        $fault->faultstring,
        $fault->faultactor,
        $fault->detail
    );
    if (isset($fault->detail->CustomerMergedException->reason)) {
      $e->reason = $fault->detail->CustomerMergedException->reason;
    }
    if (isset($fault->detail->CustomerMergedException->mergedToCustomerId)) {
      $e->mergedToCustomerId = $fault->detail->CustomerMergedException->mergedToCustomerId;
    }

    return $e;
  }

  /**
   * 
   *
   * @return mixed
   */
  public function getReason()
  {
    return $this->reason;
  }


  /**
   * 
   *
   * @return mixed
   */
  public function getMergedToCustomerId()
  {
    return $this->mergedToCustomerId;
  }


}
