<?php
/**
 * Defines the RawViaApiSubscriptionBasketItem data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * 
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiSubscriptionBasketItem.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiSubscriptionBasketItem.
 */
#[\AllowDynamicProperties]
abstract class RawViaApiSubscriptionBasketItem {

  /**
   * The reference of the scheme this tier is a member of in the form "serverId:schemeId"
   *
   * @var string
   */
  protected $schemeRef;

  /**
   * The title of the scheme this tier is a member of.
   *
   * @var string
   */
  protected $title;

  /**
   * The code of the scheme this tier is a member of.
   *
   * @var string
   */
  protected $code;

  /**
   * The cost for this scheme tier.
   *
   * @var double
   */
  protected $fee;

  /**
   * The reference for the actual tier in the form "serverId:schemeId:tierId".
   *
   * @var string
   */
  protected $tierId;

  /**
   * The reference for the tier in the form "serverId:tierId".
   *
   * @var string
   */
  protected $translationTierId;

  /**
   * The title of this scheme tier.
   *
   * @var string
   */
  protected $tierTitle;

  /**
   * Whether or not this scheme tier is gift aidable.
   *
   * @var bool
   */
  protected $isGiftAidable;

  /**
   * The gift aidable value of this scheme tier.
   *
   * @var double
   */
  protected $donationValue;

  /**
   * The concession title
   *
   * @var string
   */
  protected $concessionTitle;

  /**
   * The concession id in the form of serverId:concessionId
   *
   * @var string
   */
  protected $concessionId;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'schemeRef':
        return $this->getSchemeRef();
      case 'title':
        return $this->getTitle();
      case 'code':
        return $this->getCode();
      case 'fee':
        return $this->getFee();
      case 'tierId':
        return $this->getTierId();
      case 'translationTierId':
        return $this->getTranslationTierId();
      case 'tierTitle':
        return $this->getTierTitle();
      case 'isGiftAidable':
        return $this->getIsGiftAidable();
      case 'donationValue':
        return $this->getDonationValue();
      case 'concessionTitle':
        return $this->getConcessionTitle();
      case 'concessionId':
        return $this->getConcessionId();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The reference of the scheme this tier is a member of in the form "serverId:schemeId"
   *
   * @return string
   */
  public function getSchemeRef()
  {
    return $this->schemeRef;
  }


  /**
   * The title of the scheme this tier is a member of.
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The code of the scheme this tier is a member of.
   *
   * @return string
   */
  public function getCode()
  {
    return $this->code;
  }


  /**
   * The cost for this scheme tier.
   *
   * @return double
   */
  public function getFee()
  {
    return $this->fee;
  }


  /**
   * The reference for the actual tier in the form "serverId:schemeId:tierId".
   *
   * @return string
   */
  public function getTierId()
  {
    return $this->tierId;
  }


  /**
   * The reference for the tier in the form "serverId:tierId".
   *
   * @return string
   */
  public function getTranslationTierId()
  {
    return $this->translationTierId;
  }


  /**
   * The title of this scheme tier.
   *
   * @return string
   */
  public function getTierTitle()
  {
    return $this->tierTitle;
  }


  /**
   * Whether or not this scheme tier is gift aidable.
   *
   * @return bool
   */
  public function getIsGiftAidable()
  {
    return $this->isGiftAidable;
  }


  /**
   * The gift aidable value of this scheme tier.
   *
   * @return double
   */
  public function getDonationValue()
  {
    return $this->donationValue;
  }


  /**
   * The concession title
   *
   * @return string
   */
  public function getConcessionTitle()
  {
    return $this->concessionTitle;
  }


  /**
   * The concession id in the form of serverId:concessionId
   *
   * @return string
   */
  public function getConcessionId()
  {
    return $this->concessionId;
  }


}
