<?php
/**
 * Defines the RawViaApiDonationScheduleSummary data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Summary object of a customers donation schedule and activity against that schedule.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiDonationScheduleSummary.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiDonationScheduleSummary.
 */
#[\AllowDynamicProperties]
abstract class RawViaApiDonationScheduleSummary {

  /**
   * The reference of this donation schedule in the form "serverId:donationScheduleId".
   *
   * @var string
   */
  protected $donationScheduleRef;

  /**
   * The Id of the customer.
   *
   * @var int
   */
  protected $customerId;

  /**
   * The reference of this donation fund in the form "serverId:donationFundId".
   *
   * @var string
   */
  protected $donationFundRef;

  /**
   * The title for the Donation Fund.
   *
   * @var string
   */
  protected $fundName;

  /**
   * The type option of the Donation Fund. i.e. (One off, Recurring, Pledge)
   *
   * @var string
   */
  protected $fundType;

  /**
   * The payment types used against this donation schedule (Card or Manual).
   *
   * @var string
   */
  protected $paymentType;

  /**
   * The total amount of the pledge to which the customer committed. (If the `ViaApiDonationScheduleSummary#fundType` is
   * "Pledge")
   *
   * @var double
   */
  protected $totalPledged;

  /**
   * The total amount that has currently been paid against this donation schedule.
   *
   * @var double
   */
  protected $totalPaid;

  /**
   * The next expected payment date of the customers donation schedule.
   *
   * @var string
   */
  protected $nextExpectedPaymentDate;

  /**
   * The final expected payment date of the customers donation schedule.
   *
   * @var string
   */
  protected $finalPaymentDate;

  /**
   * The number of processed payments done for this donation schedule.
   *
   * @var int
   */
  protected $processedPaymentCount;

  /**
   * The incremental monetary value that the customer is paying every
   * `ViaApiDonationScheduleSummary#recurringContributionValue`. (If the `ViaApiDonationScheduleSummary#fundType` is
   * "Recurring")
   *
   * @var double
   */
  protected $recurringContributionValue;

  /**
   * The Payment interval of the donation schedule (WEEKLY, MONTHLY, QUARTERLY, ANNUALLY).
   *
   * @var string
   */
  protected $paymentInterval;

  /**
   * The final expected payment date of the customers donation schedule.
   *
   * @var string
   */
  protected $createdDate;

  /**
   * The current status of this Donation Schedule, possible values (TO_CALL, ACTION, ACTIVE, STOPPED, PAUSED,
   * MISSED_PAYMENT, COMPLETE).
   *
   * @var string
   */
  protected $scheduleStatus;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'donationScheduleRef':
        return $this->getDonationScheduleRef();
      case 'customerId':
        return $this->getCustomerId();
      case 'donationFundRef':
        return $this->getDonationFundRef();
      case 'fundName':
        return $this->getFundName();
      case 'fundType':
        return $this->getFundType();
      case 'paymentType':
        return $this->getPaymentType();
      case 'totalPledged':
        return $this->getTotalPledged();
      case 'totalPaid':
        return $this->getTotalPaid();
      case 'nextExpectedPaymentDate':
        return $this->getNextExpectedPaymentDate();
      case 'finalPaymentDate':
        return $this->getFinalPaymentDate();
      case 'processedPaymentCount':
        return $this->getProcessedPaymentCount();
      case 'recurringContributionValue':
        return $this->getRecurringContributionValue();
      case 'paymentInterval':
        return $this->getPaymentInterval();
      case 'createdDate':
        return $this->getCreatedDate();
      case 'scheduleStatus':
        return $this->getScheduleStatus();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The reference of this donation schedule in the form "serverId:donationScheduleId".
   *
   * @return string
   */
  public function getDonationScheduleRef()
  {
    return $this->donationScheduleRef;
  }


  /**
   * The Id of the customer.
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The reference of this donation fund in the form "serverId:donationFundId".
   *
   * @return string
   */
  public function getDonationFundRef()
  {
    return $this->donationFundRef;
  }


  /**
   * The title for the Donation Fund.
   *
   * @return string
   */
  public function getFundName()
  {
    return $this->fundName;
  }


  /**
   * The type option of the Donation Fund. i.e. (One off, Recurring, Pledge)
   *
   * @return string
   */
  public function getFundType()
  {
    return $this->fundType;
  }


  /**
   * The payment types used against this donation schedule (Card or Manual).
   *
   * @return string
   */
  public function getPaymentType()
  {
    return $this->paymentType;
  }


  /**
   * The total amount of the pledge to which the customer committed. (If the `ViaApiDonationScheduleSummary#fundType` is
   * "Pledge")
   *
   * @return double
   */
  public function getTotalPledged()
  {
    return $this->totalPledged;
  }


  /**
   * The total amount that has currently been paid against this donation schedule.
   *
   * @return double
   */
  public function getTotalPaid()
  {
    return $this->totalPaid;
  }


  /**
   * The next expected payment date of the customers donation schedule.
   *
   * @return string
   */
  public function getNextExpectedPaymentDate()
  {
    return $this->nextExpectedPaymentDate;
  }


  /**
   * The final expected payment date of the customers donation schedule.
   *
   * @return string
   */
  public function getFinalPaymentDate()
  {
    return $this->finalPaymentDate;
  }


  /**
   * The number of processed payments done for this donation schedule.
   *
   * @return int
   */
  public function getProcessedPaymentCount()
  {
    return $this->processedPaymentCount;
  }


  /**
   * The incremental monetary value that the customer is paying every
   * `ViaApiDonationScheduleSummary#recurringContributionValue`. (If the `ViaApiDonationScheduleSummary#fundType` is
   * "Recurring")
   *
   * @return double
   */
  public function getRecurringContributionValue()
  {
    return $this->recurringContributionValue;
  }


  /**
   * The Payment interval of the donation schedule (WEEKLY, MONTHLY, QUARTERLY, ANNUALLY).
   *
   * @return string
   */
  public function getPaymentInterval()
  {
    return $this->paymentInterval;
  }


  /**
   * The final expected payment date of the customers donation schedule.
   *
   * @return string
   */
  public function getCreatedDate()
  {
    return $this->createdDate;
  }


  /**
   * The current status of this Donation Schedule, possible values (TO_CALL, ACTION, ACTIVE, STOPPED, PAUSED,
   * MISSED_PAYMENT, COMPLETE).
   *
   * @return string
   */
  public function getScheduleStatus()
  {
    return $this->scheduleStatus;
  }


}
