<?php
/**
 * Defines \Red61\Via\Autoloader
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace Red61\Via;

/**
 * This autoloader provides backwards-compatibility for legacy applications.
 *
 * You will not need this if:
 * * you install the wrapper with composer
 * * include the composer autoloader in your project
 * * refer to the Red61_Via and Red61_Cache classes (rather than red61_via, red61_cache ro other mixed case variants).
 *
 * You may need this if your application:
 *
 * *  Doesn't have a PSR-0 compatible autoloader
 * *  Hasn't registered the VIA wrapper source path in the autoloader
 * *  Uses inconsistent upper and lower case to refer to the Red61_Via class
 *
 * The autoloader will automatically be registered by including the old red61_via.php file
 * from the /src directory in the wrapper.
 *
 * Including this when you don't need it will not cause any side effects or conflicts.
 *
 * @see     spec\Red61\Via\AutoloaderSpec
 */
class Autoloader {

	/**
	 * @var string
	 */
	protected $basedir;

	/**
	 * Autoload handler, attempts to load classes if found
	 *
	 * @param string $class
	 */
	function autoload($class)
    {
        $classpath = $this->_find_classpath($class);

        if (file_exists($classpath))
        {
            require $classpath;
        }
    }

	/**
	 * @param string $basedir defaults to the src path
	 */
	public function __construct($basedir = NULL)
    {
        if ($basedir  === NULL) {
            $this->basedir = realpath(__DIR__.'/../../');
        } else {
            $this->basedir = $basedir;
        }
    }

	/**
	 * Register the autoloader for use
	 *
	 * @return void
	 */
	public function register_autoloader()
    {
        spl_autoload_register(array($this, 'autoload'));
    }

	/**
	 * Constructs an expected path for the file - public to allow unit testing.
	 *
	 * @param string $class
	 * @return string
	 */
	public function _find_classpath($class)
    {
        switch ($class) {
            case 'red61_via':
                return $this->basedir.'/'.'Red61/Via.php';

            case 'red61_cache':
                return $this->basedir.'/'.'Red61/Cache.php';

            default:
                return $this->basedir.'/'.str_replace(array('_', '\\'), '/', $class.'.php');
        }
    }

}
