<?php
/**
 * Defines apiGetOrderSummaryRequestSpec - specifications for Red61\Via\ApiRequest\apiGetOrderSummaryRequest
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via\ApiRequest;

use PhpSpec\Exception\Example\FailureException;
use Red61\Via\Exception\ClientInvalidRequestException;
use spec\ObjectBehavior;
use Prophecy\Argument;

/**
 *
 * @see Red61\Via\ApiRequest\apiGetOrderSummaryRequest
 */
class apiGetOrderSummaryRequestSpec extends ObjectBehavior
{
    /**
     * Use $this->subject to get proper type hinting for the subject class
     * @var \Red61\Via\ApiRequest\apiGetOrderSummaryRequest
     */
	protected $subject;

	function it_is_initializable()
    {
		$this->subject->shouldHaveType('Red61\Via\ApiRequest\apiGetOrderSummaryRequest');
	}

	function it_is_a_preflight_filtering_request()
	{
		$this->subject->shouldHaveType('Red61\Via\ApiRequest\PreflightFilteringRequest');
	}

	/**
	 * @param \Red61\Via\Plugin\ViaApiCallNotification $notification
	 */
	function it_does_not_throw_preflight_with_order_id($notification)
	{
		$this->subject->setOrderId('123123213')->onBeforeViaCall($notification);
	}

	/**
	 * @param \Red61\Via\Plugin\ViaApiCallNotification $notification
	 *
	 * @throws \PhpSpec\Exception\Example\FailureException
	 */
	function it_throws_preflight_if_order_id_not_set($notification)
	{
		try {
			$this->subject->onBeforeViaCall($notification);
			throw new FailureException("Expected exception not thrown");
		} catch (ClientInvalidRequestException $e)
		{
			expect($e->getInvalidParameters())->toHaveKey('orderId');
		}
	}
}
