<?php
/**
 * Defines the ViaApiCardPaymentRequest VIA data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\DataObject;

/**
 * @package    Red61\Via\DataObject
 * {@inheritdoc}
 */
class ViaApiCardPaymentRequest extends \Red61\Via\RawGenerated\DataObject\RawViaApiCardPaymentRequest
{


    /**
     * Checks if an order was successful. If not, you should check the error code and take appropriate action.
     *
     * @return bool
     * @see \Red61\Via\ViaApiService::createCardPaymentOrder
     */
    public function wasSuccessful()
    {
        return $this->getErrorCode() === NULL;
    }

    /**
     * Get the error code part of the response, if any.
     *
     * @return int|null (null if there was no error)
     *
     * @see \Red61\Via\ViaApiService::createCardPaymentOrder
     */
    public function getErrorCode()
    {
        list($serverId, $orderId) = explode(':', $this->getCode());

        if ((int) $orderId > 0) {
            return NULL;
        } else {
            return (int) $orderId;
        }
    }

}
