<?php
/**
 * Defines the LazyBasketCreatingRequest interface
 *
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\ApiRequest;

/**
 * A LazyBasketCreatingRequest will first create a new basket if one is required when it is sent.
 *
 * Internally, these requests actually trigger the API client to send a getBasketSessionId request
 * before they send this.
 *
 * However, to code calling for example apiAddTicketsToBasket the result is the same as if that
 * request had itself created a basket (or thrown a TooManyCarts exception).
 *
 * @package Red61\Via\ApiRequest
 * @see \Red61\Via\ViaApiClient::send
 */
interface LazyBasketCreatingRequest {

}
