<?php
/**
 * Finds the methods of a class
 *
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 */

namespace spec\Support;


use PhpSpec\Wrapper\SubjectContainerInterface;

/**
 * Finds all methods of an object for use with asserting that values are set
 *
 * @package spec\Support
 */
class SubjectMethodFinder {

	/**
	 * @var object
	 */
	protected $object;

	/**
	 * @var \ReflectionClass
	 */
	protected $reflection;

	/**
	 * @param \PhpSpec\Wrapper\SubjectContainerInterface $subject
	 *
	 * @return static
	 */
	public static function for_subject(SubjectContainerInterface $subject)
	{
		return new static($subject->getWrappedObject());
	}

	/**
	 * @param object $object
	 */
	public function __construct($object)
	{
		$this->object     = $object;
		$this->reflection = new \ReflectionClass($object);
	}

	/**
	 * @param string $regexp
	 *
	 * @return string[]
	 */
	public function find_matching($regexp)
	{
		$methods = array();
		foreach ($this->reflection->getMethods(\ReflectionMethod::IS_PUBLIC) as $method)
		{
			if (preg_match($regexp, $method->getName()))
			{
				$methods[] = $method->getName();
			}
		}
		return $methods;
	}
}
