<?php
/**
 * Defines the RawapiGetEventDetailsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Returns the event details for a given event. This method will attempt translation of it's returned objects, where
 * available.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetEventDetailsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetEventDetailsRequest.
 */
abstract class RawapiGetEventDetailsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetEventDetails';

  /**
   * The serverId and eventId to return information for in the form "serverId:eventId"
   *
   * @var string
   */
  protected $eventRef;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The serverId and eventId to return information for in the form "serverId:eventId"
   *
   * @return string
   */
  public function getEventRef()
  {
    return $this->eventRef;
  }


  /**
   * The serverId and eventId to return information for in the form "serverId:eventId"
   *
   * @param string $eventRef
   *
   * @return $this
   */
  public function setEventRef($eventRef)
  {
    $this->eventRef = $eventRef;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
